/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.play;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.Sign;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.entity.living.Humanoid;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.entity.ChangeSignEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.living.AnimateHandEvent;
import org.spongepowered.api.event.entity.living.player.RespawnPlayerEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.network.play.client.CPlayerPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.NetworkManagerHolderBridge;
import org.spongepowered.common.bridge.server.management.PlayerListBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.registrar.BrigadierBasedRegistrar;
import org.spongepowered.common.command.registrar.BrigadierCommandRegistrar;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin
implements NetworkManagerHolderBridge {
    private static final String[] IMPL$ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final String[] IMPL$EMPTY_COMMAND_ARRAY = new String[]{""};
    @Shadow
    @Final
    public NetworkManager netManager;
    @Shadow
    public ServerPlayerEntity player;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    private Vec3d targetPos;
    @Shadow
    private double firstGoodX;
    @Shadow
    private double firstGoodY;
    @Shadow
    private double firstGoodZ;
    @Shadow
    private int movePacketCounter;
    @Shadow
    private int lastMovePacketCounter;
    @Shadow
    private int networkTickCount;
    @Shadow
    private int lastPositionUpdate;
    private @Nullable Entity impl$targetedEntity = null;
    private boolean impl$justTeleported = false;

    @Shadow
    protected abstract boolean shadow$isServerOwner();

    @Shadow
    public abstract void shadow$setPlayerLocation(double var1, double var3, double var5, float var7, float var8);

    @Override
    public NetworkManager bridge$getNetworkManager() {
        return this.netManager;
    }

    @Inject(method={"processTabComplete"}, at={@At(value="NEW", target="com/mojang/brigadier/StringReader", remap=false)}, cancellable=true)
    private void impl$getSuggestionsFromNonBrigCommand(CTabCompletePacket p_195518_1_, CallbackInfo ci) {
        String rawCommand = p_195518_1_.getCommand();
        String[] command = this.impl$extractCommandString(rawCommand);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this.player);
            CommandCause cause = CommandCause.create();
            SpongeCommandManager manager = (SpongeCommandManager)Sponge.getCommandManager();
            if (!rawCommand.contains(" ")) {
                SuggestionsBuilder builder = new SuggestionsBuilder(command[0], 0);
                if (command[0].isEmpty()) {
                    manager.getAliasesForCause(cause).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                } else {
                    manager.getAliasesThatStartWithForCause(cause, command[0]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                }
                this.netManager.sendPacket((IPacket)new STabCompletePacket(p_195518_1_.getTransactionId(), builder.build()));
                ci.cancel();
            } else {
                Optional<CommandMapping> mappingOptional = manager.getCommandMapping(command[0].toLowerCase(Locale.ROOT)).filter(x -> !(x.getRegistrar() instanceof BrigadierBasedRegistrar));
                if (mappingOptional.isPresent()) {
                    CommandMapping mapping = mappingOptional.get();
                    if (mapping.getRegistrar().canExecute(cause, mapping)) {
                        try {
                            SuggestionsBuilder builder = new SuggestionsBuilder(rawCommand, rawCommand.lastIndexOf(" ") + 1);
                            mapping.getRegistrar().suggestions(cause, mapping, command[0], command[1]).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
                            this.netManager.sendPacket((IPacket)new STabCompletePacket(p_195518_1_.getTransactionId(), builder.build()));
                        }
                        catch (CommandException e) {
                            cause.sendMessage(Identity.nil(), (Component)Component.text((String)"Unable to create suggestions for your tab completion"));
                            this.netManager.sendPacket((IPacket)new STabCompletePacket(p_195518_1_.getTransactionId(), (Suggestions)Suggestions.empty().join()));
                        }
                    } else {
                        this.netManager.sendPacket((IPacket)new STabCompletePacket(p_195518_1_.getTransactionId(), (Suggestions)Suggestions.empty().join()));
                    }
                    ci.cancel();
                }
            }
        }
    }

    @Redirect(method={"processTabComplete"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;parse(Lcom/mojang/brigadier/StringReader;Ljava/lang/Object;)Lcom/mojang/brigadier/ParseResults;", remap=false))
    private ParseResults<CommandSource> impl$informParserThisIsASuggestionCheck(CommandDispatcher<CommandSource> commandDispatcher, StringReader command, Object source) {
        return BrigadierCommandRegistrar.INSTANCE.getDispatcher().parse(command, (CommandSource)source, true);
    }

    @Redirect(method={"processUseEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;canEntityBeSeen(Lnet/minecraft/entity/Entity;)Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;markPlayerActive()V"), to=@At(value="CONSTANT", args={"doubleValue=36.0D"})))
    private boolean impl$preventMC_107103(ServerPlayerEntity serverPlayerEntity, Entity entityIn) {
        this.impl$targetedEntity = entityIn;
        return true;
    }

    @ModifyConstant(method={"processUseEntity"}, constant={@Constant(doubleValue=36.0)})
    private double impl$getPlatformReach(double thirtySix) {
        Entity targeted = this.impl$targetedEntity;
        this.impl$targetedEntity = null;
        return PlatformHooks.getInstance().getGeneralHooks().getEntityReachDistanceSq(this.player, targeted);
    }

    @Inject(method={"processPlayer"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/network/play/ServerPlayNetHandler;targetPos:Lnet/minecraft/util/math/Vec3d;")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/entity/player/ServerPlayerEntity;queuedEndExit:Z"), to=@At(value="FIELD", target="Lnet/minecraft/network/play/ServerPlayNetHandler;networkTickCount:I", ordinal=1))}, cancellable=true)
    private void impl$callMoveEntityEvent(CPlayerPacket packetIn, CallbackInfo ci) {
        Event event;
        CPlayerPacketAccessor packetInAccessor = (CPlayerPacketAccessor)packetIn;
        if (!packetInAccessor.accessor$getMoving() && !packetInAccessor.accessor$getRotating()) {
            return;
        }
        boolean goodMovementPacket = this.movePacketCounter - this.lastMovePacketCounter <= 5;
        boolean fireMoveEvent = goodMovementPacket && packetInAccessor.accessor$getMoving() && ShouldFire.MOVE_ENTITY_EVENT;
        boolean fireRotationEvent = goodMovementPacket && packetInAccessor.accessor$getRotating() && ShouldFire.ROTATE_ENTITY_EVENT;
        ServerPlayer player = (ServerPlayer)this.player;
        Vector3d fromRotation = new Vector3d(packetIn.getYaw(this.player.rotationYaw), packetIn.getPitch(this.player.rotationPitch), 0.0f);
        Vector3d fromPosition = player.getPosition();
        Vector3d toPosition = new Vector3d(packetIn.getX(this.player.getPosX()), packetIn.getY(this.player.getPosY()), packetIn.getZ(this.player.getPosZ()));
        Vector3d toRotation = new Vector3d(packetIn.getYaw(this.player.rotationYaw), packetIn.getPitch(this.player.rotationPitch), 0.0f);
        boolean significantRotation = fromRotation.distanceSquared(toRotation) > (double)0.0225f;
        Vector3d originalToPosition = toPosition;
        boolean cancelMovement = false;
        boolean cancelRotation = false;
        if (fireMoveEvent) {
            event = SpongeEventFactory.createMoveEntityEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerPlayer)this.player, fromPosition, toPosition, toPosition);
            if (SpongeCommon.postEvent(event)) {
                cancelMovement = true;
            } else {
                toPosition = event.getDestinationPosition();
            }
        }
        if (significantRotation && fireRotationEvent) {
            event = SpongeEventFactory.createRotateEntityEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerPlayer)this.player, fromRotation, toRotation);
            if (SpongeCommon.postEvent(event)) {
                cancelRotation = true;
            } else {
                toRotation = event.getToRotation();
            }
        }
        if (cancelMovement) {
            if (packetInAccessor.accessor$getRotating() && !cancelRotation) {
                ((EntityAccessor)this.player).accessor$setRotation((float)toRotation.getX(), (float)toRotation.getY());
            }
            float yaw = packetInAccessor.accessor$getRotating() && !cancelRotation ? (float)toRotation.getX() : this.player.rotationYaw;
            float pitch = packetInAccessor.accessor$getRotating() && !cancelRotation ? (float)toRotation.getY() : this.player.rotationPitch;
            this.lastPositionUpdate = this.networkTickCount;
            this.shadow$setPlayerLocation(fromPosition.getX(), fromPosition.getY(), fromPosition.getZ(), yaw, pitch);
            ci.cancel();
            return;
        }
        if (!toPosition.equals((Object)originalToPosition)) {
            int i;
            float f2;
            double d10;
            double d6;
            double d9;
            double d5;
            double d8;
            double d4 = packetIn.getX(this.player.getPosX());
            double d7 = d4 - this.firstGoodX;
            double d11 = d7 * d7 + (d8 = (d5 = packetIn.getY(this.player.getPosY())) - this.firstGoodY) * d8 + (d9 = (d6 = packetIn.getZ(this.player.getPosZ())) - this.firstGoodZ) * d9;
            if (d11 - (d10 = this.player.getMotion().lengthSquared()) > (double)((f2 = this.player.isElytraFlying() ? 300.0f : 100.0f) * (float)(i = this.movePacketCounter - this.lastMovePacketCounter)) && !this.shadow$isServerOwner()) {
                this.targetPos = VecHelper.toVec3d(toPosition);
                ((EntityAccessor)this.player).accessor$setRotation((float)toRotation.getX(), (float)toRotation.getY());
                this.lastPositionUpdate = this.networkTickCount - 21;
            } else {
                packetInAccessor.accessor$setMoving(true);
                packetInAccessor.accessor$setX(toPosition.getX());
                packetInAccessor.accessor$setY(toPosition.getY());
                packetInAccessor.accessor$setZ(toPosition.getZ());
            }
        }
    }

    @Inject(method={"processUseEntity"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;applyPlayerInteraction(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResultType;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void impl$onRightClickAtEntity(CUseEntityPacket packetIn, CallbackInfo ci, net.minecraft.world.server.ServerWorld serverworld, Entity entity) {
        InteractEntityEvent.Secondary event = SpongeCommonEventFactory.callInteractEntityEventSecondary(this.player, this.player.getHeldItem(packetIn.getHand()), entity, packetIn.getHand(), null);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"processUseEntity"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;attackTargetEntityWithCurrentItem(Lnet/minecraft/entity/Entity;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void impl$onLeftClickEntity(CUseEntityPacket packetIn, CallbackInfo ci, net.minecraft.world.server.ServerWorld serverworld, Entity entity) {
        InteractEntityEvent.Primary event = SpongeCommonEventFactory.callInteractEntityEventPrimary(this.player, this.player.getHeldItem(this.player.getActiveHand()), entity, this.player.getActiveHand(), null);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Surrogate
    public void impl$onLeftClickEntity(CUseEntityPacket packetIn, CallbackInfo ci, Entity entity) {
        InteractEntityEvent.Primary event = SpongeCommonEventFactory.callInteractEntityEventPrimary(this.player, this.player.getHeldItem(this.player.getActiveHand()), entity, this.player.getActiveHand(), null);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleAnimation"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;markPlayerActive()V")}, cancellable=true)
    private void impl$throwAnimationEvent(CAnimateHandPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        SpongeCommonEventFactory.lastAnimationPacketTick = SpongeCommon.getServer().getTickCounter();
        SpongeCommonEventFactory.lastAnimationPlayer = new WeakReference<ServerPlayerEntity>(this.player);
        if (ShouldFire.ANIMATE_HAND_EVENT) {
            HandType handType = (HandType)packetIn.getHand();
            ItemStack heldItem = this.player.getHeldItem(packetIn.getHand());
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(heldItem));
                frame.addContext(EventContextKeys.USED_HAND, handType);
                AnimateHandEvent event = SpongeEventFactory.createAnimateHandEvent(frame.getCurrentCause(), handType, (Humanoid)this.player);
                if (SpongeCommon.postEvent(event)) {
                    ci.cancel();
                }
            }
        }
    }

    @Redirect(method={"processClientStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;recreatePlayerEntity(Lnet/minecraft/entity/player/ServerPlayerEntity;Lnet/minecraft/world/dimension/DimensionType;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;", ordinal=1))
    private ServerPlayerEntity impl$usePlayerDimensionForRespawn(PlayerList playerList, ServerPlayerEntity entity, DimensionType dimensionType, boolean conqueredEnd) {
        DimensionType respawnDimension = PlatformHooks.getInstance().getDimensionHooks().getRespawnDimension(entity, dimensionType, conqueredEnd);
        net.minecraft.world.server.ServerWorld destinationWorld = this.server.getWorld(respawnDimension);
        RespawnPlayerEvent.SelectWorld event = SpongeEventFactory.createRespawnPlayerEventSelectWorld(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerWorld)destinationWorld, (ServerWorld)entity.getServerWorld(), (ServerWorld)this.server.getWorld(DimensionType.OVERWORLD), (ServerPlayer)entity);
        SpongeCommon.postEvent(event);
        return playerList.recreatePlayerEntity(entity, ((net.minecraft.world.server.ServerWorld)event.getDestinationWorld()).getDimension().getType(), conqueredEnd);
    }

    @Redirect(method={"processClientStatus"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;recreatePlayerEntity(Lnet/minecraft/entity/player/ServerPlayerEntity;Lnet/minecraft/world/dimension/DimensionType;Z)Lnet/minecraft/entity/player/ServerPlayerEntity;"))
    private ServerPlayerEntity impl$setOriginalDestinationRef(PlayerList playerList, ServerPlayerEntity playerIn, DimensionType dimension, boolean conqueredEnd) {
        ((PlayerListBridge)playerList).bridge$setOriginalDestinationDimensionForRespawn(dimension);
        return playerList.recreatePlayerEntity(playerIn, dimension, conqueredEnd);
    }

    @Redirect(method={"processUpdateSign"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/client/CUpdateSignPacket;getLines()[Ljava/lang/String;"))
    private String[] impl$callChangeSignEvent(CUpdateSignPacket packet) {
        net.minecraft.world.server.ServerWorld world = this.server.getWorld(this.player.dimension);
        BlockPos position = packet.getPosition();
        SignTileEntity sign = (SignTileEntity)world.getTileEntity(position);
        ListValue.Mutable<Component> originalLinesValue = ((Sign)sign).getValue(Keys.SIGN_LINES).orElse(null);
        ArrayList<Component> newLines = new ArrayList<Component>();
        for (String line : packet.getLines()) {
            newLines.add(SpongeAdventure.legacySection(line));
        }
        ListValue.Mutable<Component> newLinesValue = ListValue.mutableOf(Keys.SIGN_LINES.get(), newLines);
        ChangeSignEvent event = SpongeEventFactory.createChangeSignEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ListValue.Immutable<Component>)originalLinesValue.asImmutable(), newLinesValue, (Sign)sign);
        ListValue.Mutable<Component> toApply = SpongeCommon.postEvent(event) ? originalLinesValue : newLinesValue;
        ((Sign)sign).offer(toApply);
        return IMPL$ZERO_LENGTH_STRING_ARRAY;
    }

    private String[] impl$extractCommandString(String commandString) {
        if (commandString.isEmpty()) {
            return IMPL$EMPTY_COMMAND_ARRAY;
        }
        if (commandString.startsWith("/")) {
            return commandString.substring(1).split(" ", 2);
        }
        return commandString.split(" ", 2);
    }
}

