/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network.status;

import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.status.ServerStatusNetHandler;
import net.minecraft.network.status.client.CServerQueryPacket;
import net.minecraft.network.status.server.SServerInfoPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.network.status.SpongeStatusClient;
import org.spongepowered.common.network.status.SpongeStatusResponse;

@Mixin(value={ServerStatusNetHandler.class})
public abstract class ServerStatusNetHandlerMixin {
    @Shadow
    @Final
    private static ITextComponent EXIT_MESSAGE;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    @Final
    private NetworkManager networkManager;
    @Shadow
    private boolean handled;

    @Overwrite
    public void processServerQuery(CServerQueryPacket packetIn) {
        if (this.handled) {
            this.networkManager.closeChannel(EXIT_MESSAGE);
        } else {
            this.handled = true;
            ServerStatusResponse response = SpongeStatusResponse.post(this.server, new SpongeStatusClient(this.networkManager));
            if (response != null) {
                this.networkManager.sendPacket((IPacket)new SServerInfoPacket(response));
            } else {
                this.networkManager.closeChannel(null);
            }
        }
    }
}

