/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.management;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.management.PlayerProfileCache;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.management.PlayerProfileCache_ProfileEntryAccessor;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.server.management.PlayerProfileCache_ProfileEntryBridge;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={PlayerProfileCache.class})
public abstract class PlayerProfileCacheMixin
implements PlayerProfileCacheBridge {
    @Shadow
    @Final
    private Map<UUID, PlayerProfileCache_ProfileEntryAccessor> uuidToProfileEntryMap;
    @Shadow
    @Final
    private Map<String, PlayerProfileCache_ProfileEntryAccessor> usernameToProfileEntryMap;
    private boolean impl$canSave = false;

    @Shadow
    private void shadow$addEntry(com.mojang.authlib.GameProfile profile, @Nullable Date expiry) {
    }

    @Override
    public Optional<PlayerProfileCache_ProfileEntryBridge> bridge$getEntry(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.uuidToProfileEntryMap.get(uniqueId);
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.accessor$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.uuidToProfileEntryMap.remove(uniqueId, accessor);
            this.usernameToProfileEntryMap.remove(accessor.accessor$getGameProfile().getName(), accessor);
            return Optional.empty();
        }
        return Optional.of((PlayerProfileCache_ProfileEntryBridge)((Object)accessor));
    }

    @Override
    public Optional<PlayerProfileCache_ProfileEntryBridge> bridge$getEntry(String name) {
        Objects.requireNonNull(name, "name");
        String lowerName = name.toLowerCase(Locale.ROOT);
        PlayerProfileCache_ProfileEntryAccessor accessor = this.usernameToProfileEntryMap.get(lowerName);
        if (accessor == null) {
            return Optional.empty();
        }
        if (accessor.accessor$getExpirationDate().getTime() < System.currentTimeMillis()) {
            this.uuidToProfileEntryMap.remove(accessor.accessor$getGameProfile().getId(), accessor);
            this.usernameToProfileEntryMap.remove(lowerName, accessor);
            return Optional.empty();
        }
        return Optional.of((PlayerProfileCache_ProfileEntryBridge)((Object)accessor));
    }

    @Override
    public void bridge$add(com.mojang.authlib.GameProfile profile, boolean full, boolean signed) {
        com.mojang.authlib.GameProfile current;
        Objects.requireNonNull(profile, "profile");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.uuidToProfileEntryMap.get(profile.getId());
        com.mojang.authlib.GameProfile gameProfile = current = accessor == null ? null : accessor.accessor$getGameProfile();
        if (current != null && Objects.equals(current.getId(), profile.getId()) && Objects.equals(current.getName(), profile.getName()) && !full) {
            return;
        }
        this.shadow$addEntry(profile, null);
        accessor = this.uuidToProfileEntryMap.get(profile.getId());
        if (accessor == null || accessor.accessor$getGameProfile() != profile) {
            return;
        }
        PlayerProfileCache_ProfileEntryBridge bridge = (PlayerProfileCache_ProfileEntryBridge)((Object)accessor);
        bridge.bridge$setSigned(signed);
        bridge.bridge$setIsFull(full);
    }

    @Override
    public void bridge$add(GameProfile profile, boolean full, boolean signed) {
        Objects.requireNonNull(profile, "profile");
        PlayerProfileCache_ProfileEntryAccessor accessor = this.uuidToProfileEntryMap.get(profile.getUniqueId());
        com.mojang.authlib.GameProfile current = accessor == null ? null : accessor.accessor$getGameProfile();
        com.mojang.authlib.GameProfile mcProfile = SpongeGameProfile.toMcProfile(profile);
        if (current != null && Objects.equals(current.getId(), mcProfile.getId()) && Objects.equals(current.getName(), mcProfile.getName()) && !full) {
            return;
        }
        this.shadow$addEntry(mcProfile, null);
        accessor = this.uuidToProfileEntryMap.get(profile.getUniqueId());
        if (accessor == null || accessor.accessor$getGameProfile() != mcProfile) {
            return;
        }
        ((PlayerProfileCache_ProfileEntryBridge)((Object)accessor)).bridge$set(profile, full, signed);
    }

    @Override
    public void bridge$setCanSave(boolean flag) {
        this.impl$canSave = flag;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerProfileCache;load()V"))
    private void impl$callLoadAfterServerCreated(PlayerProfileCache playerProfileCache) {
    }

    @Inject(method={"addEntry(Lcom/mojang/authlib/GameProfile;Ljava/util/Date;)V"}, at={@At(value="RETURN")})
    private void impl$UpdateCacheUsername(com.mojang.authlib.GameProfile profile, Date date, CallbackInfo ci) {
        ((SpongeServer)Sponge.getServer()).getUsernameCache().setUsername(profile.getId(), profile.getName());
    }

    @Redirect(method={"lookupProfile(Lcom/mojang/authlib/GameProfileRepository;Ljava/lang/String;)Lcom/mojang/authlib/GameProfile;"}, at=@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfileRepository;findProfilesByNames([Ljava/lang/String;Lcom/mojang/authlib/Agent;Lcom/mojang/authlib/ProfileLookupCallback;)V", remap=false))
    private static void impl$LookUpViaSponge(GameProfileRepository repository, String[] names, Agent agent, ProfileLookupCallback callback) {
        GameProfileManager profileManager = Sponge.getServer().getGameProfileManager();
        profileManager.getBasicProfile(names[0]).whenComplete((profile, ex) -> {
            if (ex != null) {
                callback.onProfileLookupFailed(new com.mojang.authlib.GameProfile(null, names[0]), ex instanceof Exception ? (Exception)ex : new RuntimeException((Throwable)ex));
            } else {
                callback.onProfileLookupSucceeded(SpongeGameProfile.toMcProfile(profile));
            }
        });
    }

    @Inject(method={"save"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreSavingIfCancelled(CallbackInfo ci) {
        if (!this.impl$canSave) {
            ci.cancel();
        }
    }
}

