/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.data.meta.BannerPatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.accessor.tileentity.BannerTileEntityAccessor;
import org.spongepowered.common.bridge.CustomNameableBridge;
import org.spongepowered.common.bridge.tileentity.BannerTileEntityBridge;
import org.spongepowered.common.data.provider.item.stack.ShieldItemStackData;
import org.spongepowered.common.mixin.core.tileentity.TileEntityMixin;

@Mixin(value={BannerTileEntity.class})
public abstract class BannerTileEntityMixin
extends TileEntityMixin
implements BannerTileEntityBridge,
CustomNameableBridge {
    @Shadow
    private net.minecraft.item.DyeColor baseColor;
    @Shadow
    private ListNBT patterns;
    private List<BannerPatternLayer> impl$patternLayers = Lists.newArrayList();

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private void onSetItemValues(CallbackInfo ci) {
        this.impl$updatePatterns();
    }

    private void impl$markDirtyAndUpdate() {
        this.shadow$markDirty();
        if (this.world != null && !this.world.isRemote) {
            ((ServerWorld)this.world).getChunkProvider().markBlockChanged(this.shadow$getPos());
        }
    }

    private void impl$updatePatterns() {
        this.impl$patternLayers.clear();
        if (this.patterns != null) {
            for (INBT pattern : this.patterns) {
                this.impl$patternLayers.add(ShieldItemStackData.layerFromNbt((CompoundNBT)pattern));
            }
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public List<BannerPatternLayer> bridge$getLayers() {
        return new ArrayList<BannerPatternLayer>(this.impl$patternLayers);
    }

    @Override
    public void bridge$setLayers(List<BannerPatternLayer> layers) {
        this.impl$patternLayers = NonNullList.create();
        this.impl$patternLayers.addAll(layers);
        this.patterns = new ListNBT();
        for (BannerPatternLayer layer : this.impl$patternLayers) {
            this.patterns.add((Object)ShieldItemStackData.layerToNbt(layer));
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public DyeColor bridge$getBaseColor() {
        return (DyeColor)this.baseColor;
    }

    @Override
    public void bridge$setBaseColor(DyeColor baseColor) {
        Preconditions.checkNotNull((Object)baseColor, (Object)"Null DyeColor!");
        try {
            this.baseColor = (net.minecraft.item.DyeColor)baseColor;
        }
        catch (Exception e) {
            this.baseColor = net.minecraft.item.DyeColor.BLACK;
        }
        this.impl$markDirtyAndUpdate();
    }

    @Override
    public void bridge$setCustomDisplayName(ITextComponent component) {
        ((BannerTileEntityAccessor)((Object)this)).accessor$func_213136_a(component);
    }
}

