/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.registry.Registry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.core.ConfigHandle;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityTypeBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.tracker.BlockEntityTrackerCategory;
import org.spongepowered.common.config.tracker.BlockEntityTrackerModCategory;
import org.spongepowered.common.config.tracker.TrackerConfig;
import org.spongepowered.plugin.PluginContainer;

@Mixin(value={TileEntityType.class})
public abstract class TileEntityTypeMixin
implements ResourceKeyBridge,
TileEntityTypeBridge {
    private ResourceKey impl$key;
    private boolean impl$canTick;

    @Redirect(method={"register"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/registry/Registry;register(Lnet/minecraft/util/registry/Registry;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;"))
    private static Object impl$setKeyAndInitializeTrackerState(Registry<Object> registry, String key, Object tileEntityType) {
        PluginContainer plugin = SpongeCommon.getActivePlugin();
        Registry.register(registry, (String)key, (Object)tileEntityType);
        ResourceKeyBridge resourceKeyBridge = (ResourceKeyBridge)tileEntityType;
        resourceKeyBridge.bridge$setKey(ResourceKey.of(plugin, key));
        TrackableBridge trackableBridge = (TrackableBridge)tileEntityType;
        ConfigHandle<TrackerConfig> trackerConfigAdapter = SpongeGameConfigs.getTracker();
        BlockEntityTrackerCategory blockEntityTracker = trackerConfigAdapter.get().getBlockEntityTracker();
        BlockEntityTrackerModCategory modCapturing = blockEntityTracker.getModMappings().get(plugin.getMetadata().getId());
        if (modCapturing == null) {
            modCapturing = new BlockEntityTrackerModCategory();
            blockEntityTracker.getModMappings().put(plugin.getMetadata().getId(), modCapturing);
        }
        if (!modCapturing.isEnabled()) {
            trackableBridge.bridge$setAllowsBlockBulkCaptures(false);
            trackableBridge.bridge$setAllowsBlockEventCreation(false);
            trackableBridge.bridge$setAllowsEntityBulkCaptures(false);
            trackableBridge.bridge$setAllowsEntityEventCreation(false);
            modCapturing.getBlockBulkCaptureMap().computeIfAbsent(key, k -> false);
            modCapturing.getEntityBulkCaptureMap().computeIfAbsent(key, k -> false);
            modCapturing.getBlockEventCreationMap().computeIfAbsent(key, k -> false);
            modCapturing.getEntityEventCreationMap().computeIfAbsent(key, k -> false);
        } else {
            trackableBridge.bridge$setAllowsBlockBulkCaptures(modCapturing.getBlockBulkCaptureMap().computeIfAbsent(key, k -> true));
            trackableBridge.bridge$setAllowsBlockEventCreation(modCapturing.getBlockEventCreationMap().computeIfAbsent(key, k -> true));
            trackableBridge.bridge$setAllowsEntityBulkCaptures(modCapturing.getEntityBulkCaptureMap().computeIfAbsent(key, k -> true));
            trackableBridge.bridge$setAllowsEntityEventCreation(modCapturing.getEntityEventCreationMap().computeIfAbsent(key, k -> true));
        }
        if (blockEntityTracker.autoPopulateData()) {
            trackerConfigAdapter.save();
        }
        return tileEntityType;
    }

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public boolean bridge$canTick() {
        return this.impl$canTick;
    }

    @Override
    public boolean bridge$setCanTick(boolean canTick) {
        this.impl$canTick = canTick;
        return this.impl$canTick;
    }
}

