/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.chunk;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.chunk.CacheKeyBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin
implements ChunkBridge,
CacheKeyBridge {
    @Shadow
    @Final
    private World world;
    @Shadow
    @Final
    private ChunkPos pos;
    @Shadow
    @Final
    private ClassInheritanceMultiMap<Entity>[] entityLists;
    @Shadow
    @Final
    private Map<BlockPos, TileEntity> tileEntities;
    @Shadow
    private boolean loaded;
    @Shadow
    private boolean dirty;
    private long impl$scheduledForUnload = -1L;
    private boolean impl$persistedChunk = false;
    private boolean impl$isSpawning = false;
    private final Chunk[] impl$neighbors = new Chunk[4];
    private long impl$cacheKey;

    @Shadow
    @Nullable
    public abstract TileEntity getTileEntity(BlockPos var1, Chunk.CreateEntityType var2);

    @Shadow
    public abstract BlockState getBlockState(BlockPos var1);

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/world/biome/BiomeContainer;Lnet/minecraft/util/palette/UpgradeData;Lnet/minecraft/world/ITickList;Lnet/minecraft/world/ITickList;J[Lnet/minecraft/world/chunk/ChunkSection;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private void impl$onConstruct(World p_i225781_1_, ChunkPos p_i225781_2_, BiomeContainer p_i225781_3_, UpgradeData p_i225781_4_, ITickList<Block> p_i225781_5_, ITickList<Fluid> p_i225781_6_, long p_i225781_7_, ChunkSection[] p_i225781_9_, Consumer<Chunk> p_i225781_10_, CallbackInfo ci) {
        this.impl$cacheKey = ChunkPos.asLong((int)p_i225781_2_.x, (int)p_i225781_2_.z);
    }

    @Override
    public Chunk[] bridge$getNeighborArray() {
        return Arrays.copyOf(this.impl$neighbors, this.impl$neighbors.length);
    }

    @Override
    public void bridge$markChunkDirty() {
        this.dirty = true;
    }

    @Override
    public boolean bridge$isQueuedForUnload() {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public boolean bridge$isPersistedChunk() {
        return this.impl$persistedChunk;
    }

    @Override
    public boolean bridge$isSpawning() {
        return this.impl$isSpawning;
    }

    @Override
    public void bridge$setIsSpawning(boolean spawning) {
        this.impl$isSpawning = spawning;
    }

    @Override
    public void bridge$addTrackedBlockPosition(Block block, BlockPos pos, User user, PlayerTracker.Type trackerType) {
    }

    @Override
    public Map<Integer, PlayerTracker> bridge$getTrackedIntPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Short, PlayerTracker> bridge$getTrackedShortPlayerPositions() {
        return Collections.emptyMap();
    }

    @Override
    public Optional<User> bridge$getBlockCreator(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockCreatorUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<User> bridge$getBlockNotifier(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> bridge$getBlockNotifierUUID(BlockPos pos) {
        return Optional.empty();
    }

    @Override
    public void bridge$setBlockNotifier(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void bridge$setBlockCreator(BlockPos pos, @Nullable UUID uuid) {
    }

    @Override
    public void bridge$setTrackedIntPlayerPositions(Map<Integer, PlayerTracker> trackedPositions) {
    }

    @Override
    public void bridge$setTrackedShortPlayerPositions(Map<Short, PlayerTracker> trackedPositions) {
    }

    @Override
    public void bridge$setNeighborChunk(int index, @Nullable Chunk chunk) {
        this.impl$neighbors[index] = chunk;
    }

    @Override
    @Nullable
    public Chunk bridge$getNeighborChunk(int index) {
        return this.impl$neighbors[index];
    }

    @Override
    public List<Chunk> bridge$getNeighbors() {
        ArrayList<Chunk> neighborList = new ArrayList<Chunk>();
        for (Chunk neighbor : this.impl$neighbors) {
            if (neighbor == null) continue;
            neighborList.add(neighbor);
        }
        return neighborList;
    }

    @Override
    public boolean bridge$areNeighborsLoaded() {
        for (int i = 0; i < 4; ++i) {
            if (this.impl$neighbors[i] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void bridge$setNeighbor(Direction direction, @Nullable Chunk neighbor) {
        this.impl$neighbors[SpongeCommon.directionToIndex((Direction)direction)] = neighbor;
    }

    @Override
    public long bridge$getScheduledForUnload() {
        return this.impl$scheduledForUnload;
    }

    @Override
    public void bridge$setScheduledForUnload(long scheduled) {
        this.impl$scheduledForUnload = scheduled;
    }

    @Override
    public boolean bridge$isActive() {
        if (this.bridge$isPersistedChunk()) {
            return true;
        }
        return this.loaded && !this.bridge$isQueuedForUnload() && this.bridge$getScheduledForUnload() == -1L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("World", (Object)this.world).add("Position", this.pos.x + this.pos.z).toString();
    }

    @Override
    public long bridge$getCacheKey() {
        return this.impl$cacheKey;
    }
}

