/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.server;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;

@Mixin(value={ChunkManager.class})
public abstract class ChunkManagerMixin {
    @Shadow
    @Final
    private ServerWorld world;

    @Shadow
    protected abstract boolean shadow$chunkSave(IChunk var1);

    @Shadow
    @Nullable
    protected abstract CompoundNBT loadChunkData(ChunkPos var1) throws IOException;

    @Redirect(method={"chunkSave"}, at=@At(value="INVOKE", target="Lnet/minecraft/village/PointOfInterestManager;saveIfDirty(Lnet/minecraft/util/math/ChunkPos;)V"))
    private void impl$useSerializationBehaviorForPOI(PointOfInterestManager pointOfInterestManager, ChunkPos p_219112_1_) {
        WorldInfoBridge infoBridge = (WorldInfoBridge)this.world.getWorldInfo();
        SerializationBehavior serializationBehavior = infoBridge.bridge$getSerializationBehavior();
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            pointOfInterestManager.saveIfDirty(p_219112_1_);
        }
    }

    @Redirect(method={"chunkSave"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkManager;loadChunkData(Lnet/minecraft/util/math/ChunkPos;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$useSerializationBehaviorForChunkSave(ChunkManager chunkManager, ChunkPos pos) throws IOException {
        WorldInfoBridge infoBridge = (WorldInfoBridge)this.world.getWorldInfo();
        SerializationBehavior serializationBehavior = infoBridge.bridge$getSerializationBehavior();
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            return this.loadChunkData(pos);
        }
        return null;
    }

    @Redirect(method={"chunkSave"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/storage/ChunkSerializer;write(Lnet/minecraft/world/server/ServerWorld;Lnet/minecraft/world/chunk/IChunk;)Lnet/minecraft/nbt/CompoundNBT;"))
    private CompoundNBT impl$useSerializationBehaviorForChunkSave(ServerWorld worldIn, IChunk chunkIn) {
        WorldInfoBridge infoBridge = (WorldInfoBridge)worldIn.getWorldInfo();
        SerializationBehavior serializationBehavior = infoBridge.bridge$getSerializationBehavior();
        if (serializationBehavior == SerializationBehavior.AUTOMATIC || serializationBehavior == SerializationBehavior.MANUAL) {
            return ChunkSerializer.write((ServerWorld)worldIn, (IChunk)chunkIn);
        }
        return null;
    }

    @Redirect(method={"chunkSave"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkManager;writeChunk(Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$doNotWriteIfWeHaveNoData(ChunkManager chunkManager, ChunkPos pos, CompoundNBT compound) {
        if (compound == null) {
            return;
        }
        chunkManager.writeChunk(pos, compound);
    }
}

