/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.server;

import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;

@Mixin(targets={"net/minecraft/world/server/ChunkManager$EntityTracker"})
public abstract class ChunkManager_EntityTrackerMixin {
    @Shadow
    @Final
    private Entity entity;

    @Redirect(method={"sendToAllTracking(Lnet/minecraft/network/IPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/play/ServerPlayNetHandler;sendPacket(Lnet/minecraft/network/IPacket;)V"))
    private void impl$sendQueuedHumanPackets(ServerPlayNetHandler serverPlayNetHandler, IPacket<?> packetIn) {
        serverPlayNetHandler.sendPacket(packetIn);
        if (this.entity instanceof HumanEntity) {
            Stream<IPacket<?>> packets = ((HumanEntity)this.entity).popQueuedPackets(serverPlayNetHandler.player);
            packets.forEach(arg_0 -> ((ServerPlayNetHandler)serverPlayNetHandler.player.connection).sendPacket(arg_0));
        }
    }

    @Inject(method={"sendToAllTracking(Lnet/minecraft/network/IPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$ignoreVanished(IPacket<?> p_219391_1_, CallbackInfo ci) {
        if (this.entity instanceof VanishableBridge && ((VanishableBridge)this.entity).bridge$isVanished()) {
            ci.cancel();
        }
    }

    @Redirect(method={"updateTrackingState(Lnet/minecraft/entity/player/ServerPlayerEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isSpectatedByPlayer(Lnet/minecraft/entity/player/ServerPlayerEntity;)Z"))
    private boolean impl$isSpectatedOrVanished(Entity entity, ServerPlayerEntity player) {
        if (entity instanceof VanishableBridge && ((VanishableBridge)entity).bridge$isVanished()) {
            return false;
        }
        return entity.isSpectatedByPlayer(player);
    }
}

