/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;

@Mixin(value={SaveHandler.class})
public abstract class SaveHandlerMixin
implements IPlayerFileData {
    private @Nullable Exception impl$capturedException;
    private @Nullable Path impl$file;

    @Shadow
    public abstract File shadow$getWorldDirectory();

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SessionLockException;<init>(Ljava/lang/String;)V", ordinal=0, remap=false))
    private String modifyMinecraftExceptionOutputIfNotInitializationTime(String message) {
        return "The save folder for world " + this.shadow$getWorldDirectory() + " is being accessed from another location, aborting";
    }

    @ModifyArg(method={"checkSessionLock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/SessionLockException;<init>(Ljava/lang/String;)V", ordinal=1, remap=false))
    private String modifyMinecraftExceptionOutputIfIOException(String message) {
        return "Failed to check session lock for world " + this.shadow$getWorldDirectory() + ", aborting";
    }

    @Inject(method={"saveWorldInfoWithPlayer"}, at={@At(value="RETURN")})
    private void impl$saveSpongeLevelData(WorldInfo info, CompoundNBT compound, CallbackInfo ci) {
        if (!Sponge.isServerAvailable() || !((WorldInfoBridge)info).bridge$isValid()) {
            return;
        }
        try {
            CompoundNBT spongeLevelCompound = new CompoundNBT();
            ((WorldInfoBridge)info).bridge$writeSpongeLevelData(spongeLevelCompound);
            if (spongeLevelCompound.isEmpty()) {
                new PrettyPrinter().add("Sponge Level NBT for world %s is empty!", new Object[]{info.getWorldName()}).centre().hr().add("When trying to save Sponge data for the world %s, an empty NBT compound was provided. The old Sponge data file was left intact.", new Object[]{info.getWorldName()}).add().add("The following information may be useful in debugging:").add().add("World: %s", new Object[]{((ResourceKeyBridge)info).bridge$getKey()}).add("Valid flag: ", new Object[]{((WorldInfoBridge)info).bridge$isValid()}).add().add("Stack trace:").add((Throwable)new Exception()).print(System.err);
                return;
            }
            Path spongeLevelFile = this.shadow$getWorldDirectory().toPath().resolve("level_sponge.dat");
            Path newSpongeLevelFile = spongeLevelFile.resolveSibling("level_sponge.dat_new");
            Path oldSpongeLevelFile = spongeLevelFile.resolveSibling("level_sponge.dat_old");
            try (OutputStream stream = Files.newOutputStream(newSpongeLevelFile, new OpenOption[0]);){
                CompressedStreamTools.writeCompressed((CompoundNBT)spongeLevelCompound, (OutputStream)stream);
            }
            if (newSpongeLevelFile.toFile().length() == 0L) {
                new PrettyPrinter().add("Zero length level_sponge.dat file was created for %s!", new Object[]{info.getWorldName()}).centre().hr().add("When saving the data file for the world %s, a zero length file was written. Sponge has discarded this file.", new Object[]{info.getWorldName()}).add().add("The following information may be useful in debugging:").add().add("World: %s", new Object[]{((ResourceKeyBridge)info).bridge$getKey()}).add("Is Mod Created: ", new Object[]{((WorldInfoBridge)info).bridge$isModCreated()}).add("Valid flag: ", new Object[]{((WorldInfoBridge)info).bridge$isValid()}).add().add("Stack trace:").add((Throwable)new Exception()).print(System.err);
                Files.deleteIfExists(newSpongeLevelFile);
                return;
            }
            if (Files.exists(spongeLevelFile, new LinkOption[0])) {
                Files.copy(spongeLevelFile, oldSpongeLevelFile, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.move(newSpongeLevelFile, spongeLevelFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Inject(method={"loadWorldInfo"}, at={@At(value="RETURN")})
    private void impl$loadSpongeLevelDataBeforeVanilla(CallbackInfoReturnable<WorldInfo> cir) {
        if (!Sponge.isServerAvailable()) {
            return;
        }
        WorldInfo info = (WorldInfo)cir.getReturnValue();
        Path spongeLevelFile = this.shadow$getWorldDirectory().toPath().resolve("level_sponge.dat");
        Path oldSpongeLevelFile = spongeLevelFile.resolveSibling("level_sponge.dat_old");
        boolean exceptionRaised = false;
        if (Files.exists(spongeLevelFile, new LinkOption[0])) {
            if (this.impl$loadSpongeLevelData(info, spongeLevelFile, true)) {
                return;
            }
            exceptionRaised = true;
        }
        if (Files.exists(oldSpongeLevelFile, new LinkOption[0])) {
            if (this.impl$loadSpongeLevelData(info, oldSpongeLevelFile, false)) {
                if (exceptionRaised) {
                    SpongeCommon.getLogger().warn("Successfully loaded backup data file {} for world '{}'.", (Object)oldSpongeLevelFile.getFileName().toString(), (Object)info.getWorldName());
                    try {
                        Files.deleteIfExists(oldSpongeLevelFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Failed to delete the old Sponge level file in world '%s'!", info.getWorldName()), e);
                    }
                }
                return;
            }
            exceptionRaised = true;
        }
        if (exceptionRaised) {
            throw new RuntimeException("Unable to load sponge level data for world '" + info.getWorldName() + "'!");
        }
    }

    @Redirect(method={"readPlayerData"}, at=@At(value="INVOKE", target="Ljava/io/File;isFile()Z", remap=false))
    private boolean impl$grabFileToField(File localFile) {
        boolean isFile = localFile.isFile();
        this.impl$file = isFile ? localFile.toPath() : null;
        return isFile;
    }

    @Redirect(method={"readPlayerData"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;read(Lnet/minecraft/nbt/CompoundNBT;)V"))
    private void impl$readSpongePlayerData(PlayerEntity playerEntity, CompoundNBT compound) throws IOException {
        playerEntity.read(compound);
        ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().readPlayerData(compound, null, this.impl$file == null ? null : Files.readAttributes(this.impl$file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toInstant());
        this.impl$file = null;
    }

    @Inject(method={"writePlayerData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompressedStreamTools;writeCompressed(Lnet/minecraft/nbt/CompoundNBT;Ljava/io/OutputStream;)V", shift=At.Shift.AFTER)})
    private void impl$saveSpongePlayerData(PlayerEntity player, CallbackInfo callbackInfo) {
        ((SpongeServer)Sponge.getServer()).getPlayerDataManager().savePlayer(player.getUniqueID());
    }

    @Inject(method={"writePlayerData"}, at={@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void impl$trackExceptionForLogging(PlayerEntity player, CallbackInfo ci, Exception exception) {
        this.impl$capturedException = exception;
    }

    @Redirect(method={"writePlayerData"}, at=@At(value="INVOKE", target="Lorg/apache/logging/log4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V", remap=false))
    private void impl$useStoredException(Logger logger, String message, Object param) {
        logger.warn(message, param, (Object)this.impl$capturedException);
        this.impl$capturedException = null;
    }

    private boolean impl$loadSpongeLevelData(WorldInfo info, Path levelFile, boolean isCurrent) {
        CompoundNBT compound;
        try (InputStream stream = Files.newInputStream(levelFile, new OpenOption[0]);){
            compound = CompressedStreamTools.readCompressed((InputStream)stream);
        }
        catch (Exception ex) {
            PrettyPrinter errorPrinter = new PrettyPrinter().add("Unable to load level data from world '%s' for file '%s'!", new Object[]{info.getWorldName(), levelFile.getFileName().toString()}).centre().hr();
            Path corrupted = levelFile.getParent().resolve(levelFile.getFileName().toString() + ".corrupted-" + DateTimeFormatter.ISO_INSTANT.format(Instant.now()).replaceAll(":", "") + ".dat");
            try {
                Files.copy(levelFile, corrupted, new CopyOption[0]);
                errorPrinter.add("We have backed up the corrupted file to %s. Please keep hold of this, it may be useful to Sponge developers.", new Object[]{corrupted.getFileName()});
            }
            catch (IOException e) {
                errorPrinter.add("We were unable to copy the corrupted file.");
            }
            if (isCurrent) {
                errorPrinter.add("We will try to load the backup file (if it exists)");
            }
            errorPrinter.hr().add("Exception:").add((Throwable)ex).print(System.err);
            return false;
        }
        ((WorldInfoBridge)info).bridge$readSpongeLevelData(compound);
        return true;
    }
}

