/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.storage;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

@Mixin(value={WorldInfo.class})
public abstract class WorldInfoMixin
implements ResourceKeyBridge,
WorldInfoBridge {
    @Shadow
    private String levelName;
    @Shadow
    private Difficulty difficulty;
    private @Nullable ResourceKey impl$key;
    private @Nullable Integer impl$dimensionId;
    private @Nullable UUID impl$uniqueId;
    private SpongeDimensionType impl$logicType;
    private InheritableConfigHandle<WorldConfig> impl$configAdapter = SpongeGameConfigs.createDetached();
    private boolean impl$modCreated;
    private final BiMap<Integer, UUID> impl$playerUniqueIdMap = HashBiMap.create();
    private final List<UUID> impl$pendingUniqueIds = new ArrayList<UUID>();
    private int impl$trackedUniqueIdCount = 0;
    private boolean impl$hasCustomDifficulty = false;

    @Shadow
    public abstract String shadow$getWorldName();

    @Shadow
    public abstract WorldType shadow$getGenerator();

    @Shadow
    public abstract int shadow$getSpawnX();

    @Shadow
    public abstract int shadow$getSpawnY();

    @Shadow
    public abstract int shadow$getSpawnZ();

    @Shadow
    public abstract GameType shadow$getGameType();

    @Shadow
    public abstract boolean shadow$isHardcore();

    @Shadow
    public abstract Difficulty shadow$getDifficulty();

    @Shadow
    public abstract void shadow$populateFromWorldSettings(WorldSettings var1);

    @Override
    public ResourceKey bridge$getKey() {
        return this.impl$key;
    }

    @Override
    public void bridge$setKey(ResourceKey key) {
        this.impl$key = key;
    }

    @Override
    public @Nullable ServerWorld bridge$getWorld() {
        if (!Sponge.isServerAvailable()) {
            return null;
        }
        ServerWorld world = ((SpongeServer)SpongeCommon.getServer()).getWorldManager().getWorld0(this.bridge$getKey());
        if (world == null) {
            return null;
        }
        if (world.getWorldInfo() != (WorldInfo)this) {
            return null;
        }
        return world;
    }

    @Override
    public Integer bridge$getDimensionId() {
        return this.impl$dimensionId;
    }

    @Override
    public boolean bridge$isValid() {
        String levelName = this.shadow$getWorldName();
        return this.impl$key != null && levelName != null && !levelName.equals("") && !levelName.equals("MpServer");
    }

    @Override
    public boolean bridge$isSinglePlayerProperties() {
        return this.levelName != null && this.levelName.equals("MpServer");
    }

    @Override
    public void bridge$setDimensionId(DimensionType type) {
        this.impl$dimensionId = type.getId() + 1;
    }

    @Override
    public SpongeDimensionType bridge$getLogicType() {
        return this.impl$logicType;
    }

    @Override
    public void bridge$setLogicType(SpongeDimensionType dimensionType, boolean updatePlayers) {
        ServerWorld serverWorld;
        this.impl$logicType = dimensionType;
        if (updatePlayers && (serverWorld = this.bridge$getWorld()) != null) {
            ((WorldBridge)serverWorld).bridge$adjustDimensionLogic(dimensionType);
        }
    }

    @Override
    public UUID bridge$getUniqueId() {
        return this.impl$uniqueId;
    }

    @Override
    public void bridge$setUniqueId(UUID uniqueId) {
        this.impl$uniqueId = uniqueId;
    }

    @Override
    public boolean bridge$hasCustomDifficulty() {
        return this.impl$hasCustomDifficulty;
    }

    @Override
    public void bridge$forceSetDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
        this.impl$updateWorldForDifficultyChange();
    }

    @Override
    public boolean bridge$isEnabled() {
        return ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().isWorldEnabled();
    }

    @Override
    public void bridge$setEnabled(boolean state) {
        ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().setWorldEnabled(state);
    }

    @Override
    public boolean bridge$isPVPEnabled() {
        return ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().getPVPEnabled();
    }

    @Override
    public void bridge$setPVPEnabled(boolean state) {
        ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().setPVPEnabled(state);
    }

    @Override
    public boolean bridge$doesGenerateBonusChest() {
        return ((WorldConfig)this.impl$configAdapter.get()).getWorld().getGenerateBonusChest();
    }

    @Override
    public void bridge$setGenerateBonusChest(boolean state) {
        ((WorldConfig)this.impl$configAdapter.get()).getWorld().setGenerateBonusChest(state);
    }

    @Override
    public boolean bridge$doesLoadOnStartup() {
        return ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().getLoadOnStartup();
    }

    @Override
    public void bridge$setLoadOnStartup(boolean state) {
        ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().setLoadOnStartup(state);
    }

    @Override
    public boolean bridge$doesKeepSpawnLoaded() {
        return ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().getKeepSpawnLoaded();
    }

    @Override
    public void bridge$setKeepSpawnLoaded(boolean state) {
        ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().setKeepSpawnLoaded(state);
    }

    @Override
    public boolean bridge$doesGenerateSpawnOnLoad() {
        return ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().getGenerateSpawnOnLoad();
    }

    @Override
    public void bridge$setGenerateSpawnOnLoad(boolean state) {
        ((WorldConfig)this.bridge$getConfigAdapter().get()).getWorld().setGenerateSpawnOnLoad(state);
    }

    @Override
    public SerializationBehavior bridge$getSerializationBehavior() {
        return ((WorldConfig)this.impl$configAdapter.get()).getWorld().getSerializationBehavior();
    }

    @Override
    public void bridge$setSerializationBehavior(SerializationBehavior behavior) {
        ((WorldConfig)this.impl$configAdapter.get()).getWorld().setSerializationBehavior(behavior);
    }

    @Override
    public boolean bridge$isModCreated() {
        return this.impl$modCreated;
    }

    @Override
    public void bridge$setModCreated(boolean state) {
        this.impl$modCreated = state;
    }

    @Override
    public InheritableConfigHandle<WorldConfig> bridge$getConfigAdapter() {
        if (this.impl$configAdapter == null) {
            this.impl$configAdapter = this.bridge$isValid() ? SpongeGameConfigs.createWorld(this.bridge$getLogicType(), this.bridge$getKey()) : SpongeGameConfigs.createDetached();
        }
        return this.impl$configAdapter;
    }

    @Override
    public void bridge$setConfigAdapter(InheritableConfigHandle<WorldConfig> adapter) {
        this.impl$configAdapter = Objects.requireNonNull(adapter, "adapter");
    }

    @Override
    public int bridge$getIndexForUniqueId(UUID uniqueId) {
        Integer index = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)uniqueId);
        if (index != null) {
            return index;
        }
        this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount, (Object)uniqueId);
        this.impl$pendingUniqueIds.add(uniqueId);
        return this.impl$trackedUniqueIdCount++;
    }

    @Override
    public Optional<UUID> bridge$getUniqueIdForIndex(int index) {
        return Optional.ofNullable(this.impl$playerUniqueIdMap.get((Object)index));
    }

    @Override
    public void bridge$saveConfig() {
        if (this.impl$configAdapter != null) {
            this.impl$configAdapter.save();
        }
    }

    @Override
    public void bridge$writeSpongeLevelData(CompoundNBT compound) {
        if (!this.bridge$isValid()) {
            return;
        }
        CompoundNBT spongeDataCompound = new CompoundNBT();
        spongeDataCompound.putInt("DataVersion", 1);
        spongeDataCompound.putString("Key", this.impl$key.getFormatted());
        if (this.impl$dimensionId != null) {
            spongeDataCompound.putInt("dimensionId", this.impl$dimensionId.intValue());
        }
        spongeDataCompound.putString("dimensionType", this.impl$logicType.getKey().toString());
        spongeDataCompound.putUniqueId("UUID", this.impl$uniqueId);
        spongeDataCompound.putBoolean("isModCreated", this.impl$modCreated);
        spongeDataCompound.putBoolean("HasCustomDifficulty", this.impl$hasCustomDifficulty);
        Iterator<UUID> iter = this.impl$pendingUniqueIds.iterator();
        ListNBT playerIdList = spongeDataCompound.getList("PlayerIdTable", 10);
        while (iter.hasNext()) {
            CompoundNBT playerIdCompound = new CompoundNBT();
            compound.putUniqueId("UUID", iter.next());
            playerIdList.add((Object)playerIdCompound);
            iter.remove();
        }
        compound.put("SpongeData", (INBT)spongeDataCompound);
    }

    @Override
    public void bridge$readSpongeLevelData(CompoundNBT compound) {
        if (!compound.contains("SpongeData")) {
            return;
        }
        CompoundNBT spongeDataCompound = compound.getCompound("SpongeData");
        if (!spongeDataCompound.contains("Key")) {
            return;
        }
        if (!spongeDataCompound.hasUniqueId("UUID")) {
            return;
        }
        this.impl$key = ResourceKey.resolve(spongeDataCompound.getString("Key"));
        if (spongeDataCompound.contains("dimensionId")) {
            this.impl$dimensionId = spongeDataCompound.getInt("dimensionId");
        }
        String rawDimensionType = spongeDataCompound.getString("dimensionType");
        this.impl$logicType = (SpongeDimensionType)SpongeCommon.getRegistry().getCatalogRegistry().get(org.spongepowered.api.world.dimension.DimensionType.class, ResourceKey.resolve(rawDimensionType)).orElseGet(() -> {
            SpongeCommon.getLogger().warn("WorldProperties '{}' specifies dimension type '{}' which does not exist, defaulting to '{}'", (Object)this.shadow$getWorldName(), (Object)rawDimensionType, (Object)DimensionTypes.OVERWORLD.get().getKey());
            return DimensionTypes.OVERWORLD.get();
        });
        this.impl$uniqueId = spongeDataCompound.getUniqueId("UUID");
        this.impl$hasCustomDifficulty = spongeDataCompound.getBoolean("HasCustomDifficulty");
        this.impl$modCreated = spongeDataCompound.getBoolean("isModCreated");
        this.impl$trackedUniqueIdCount = 0;
        if (spongeDataCompound.contains("PlayerIdTable", 9)) {
            ListNBT playerIdList = spongeDataCompound.getList("PlayerIdTable", 10);
            Iterator iter = playerIdList.iterator();
            while (iter.hasNext()) {
                CompoundNBT playerIdComponent = (CompoundNBT)iter.next();
                UUID playerUuid = playerIdComponent.getUniqueId("UUID");
                Integer playerIndex = (Integer)this.impl$playerUniqueIdMap.inverse().get((Object)playerUuid);
                if (playerIndex == null) {
                    this.impl$playerUniqueIdMap.put((Object)this.impl$trackedUniqueIdCount++, (Object)playerUuid);
                    continue;
                }
                iter.remove();
            }
        }
    }

    @Redirect(method={"<init>(Lnet/minecraft/world/WorldSettings;Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/WorldInfo;populateFromWorldSettings(Lnet/minecraft/world/WorldSettings;)V"))
    private void impl$setupBeforeSettingsPopulation(WorldInfo info, WorldSettings settings, WorldSettings settingsB, String levelName) {
        this.levelName = levelName;
        this.shadow$populateFromWorldSettings(settingsB);
    }

    @Inject(method={"populateFromWorldSettings"}, at={@At(value="TAIL")})
    private void impl$fillInfo(WorldSettings settings, CallbackInfo ci) {
        ((WorldSettingsBridge)settings).bridge$populateInfo((WorldInfo)this);
    }

    @Overwrite
    public void setDifficulty(Difficulty newDifficulty) {
        if (this instanceof DerivedWorldInfo) {
            return;
        }
        this.impl$hasCustomDifficulty = true;
        this.difficulty = newDifficulty;
        this.impl$updateWorldForDifficultyChange();
    }

    public void impl$updateWorldForDifficultyChange() {
        ServerWorld serverWorld = this.bridge$getWorld();
        if (serverWorld == null) {
            return;
        }
        MinecraftServer server = serverWorld.getServer();
        if (this.difficulty == Difficulty.HARD) {
            serverWorld.setAllowedSpawnTypes(true, true);
        } else if (server.isSinglePlayer()) {
            serverWorld.setAllowedSpawnTypes(this.difficulty != Difficulty.PEACEFUL, true);
        } else {
            serverWorld.setAllowedSpawnTypes(((MinecraftServerAccessor)server).accessor$allowSpawnMonsters(), server.getCanSpawnAnimals());
        }
        serverWorld.getPlayers().forEach(player -> player.connection.sendPacket((IPacket)new SServerDifficultyPacket(this.difficulty, ((WorldInfo)this).isDifficultyLocked())));
    }

    public String toString() {
        return new StringJoiner(", ", WorldInfo.class.getSimpleName() + "[", "]").add("key=" + this.impl$key).add("dimensionType=" + this.impl$logicType).add("generator=" + this.shadow$getGenerator()).add("modCreated=" + this.impl$modCreated).add("spawnX=" + this.shadow$getSpawnX()).add("spawnY=" + this.shadow$getSpawnY()).add("spawnZ=" + this.shadow$getSpawnZ()).add("gameType=" + this.shadow$getGameType()).add("hardcore=" + this.shadow$isHardcore()).add("difficulty=" + this.shadow$getDifficulty()).toString();
    }
}

