/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollision.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.entitycollision.entity.EntityMixin_EntityCollision;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin_EntityCollision
extends EntityMixin_EntityCollision {
    private boolean runningCollideWithNearby = false;

    @Shadow
    protected abstract void shadow$collideWithEntity(Entity var1);

    @Inject(method={"livingTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;collideWithNearbyEntities()V")})
    private void collisions$canUpdateCollisions(CallbackInfo ci) {
        this.runningCollideWithNearby = true;
    }

    @Inject(method={"livingTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;collideWithNearbyEntities()V", shift=At.Shift.AFTER)})
    private void collisions$resetCanUpdateCollisions(CallbackInfo ci) {
        this.runningCollideWithNearby = false;
    }

    @Override
    public boolean collision$isRunningCollideWithNearby() {
        return this.runningCollideWithNearby;
    }

    @Redirect(method={"collideWithNearbyEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;size()I", remap=false))
    private int collisions$collideWithNearbyUseOurCache(List<Entity> list) {
        for (Entity entity : list) {
            if (this.shadow$getEntityWorld().isRemote() || entity == null || entity instanceof PlayerEntity || entity instanceof EnderDragonEntity) continue;
            if (this.collision$requiresCollisionsCacheRefresh()) {
                this.collision$initializeCollisionState(this.shadow$getEntityWorld());
                this.collision$requiresCollisionsCacheRefresh(false);
            }
            if (this.collision$getMaxCollisions() >= 0 && list.size() >= this.collision$getMaxCollisions()) break;
            this.shadow$collideWithEntity(entity);
        }
        return 0;
    }
}

