/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.inventory.api.entity.player;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.container.ContainerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.inventory.InventoryEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.mixin.inventory.api.entity.player.PlayerEntityMixin_Inventory_API;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin_Inventory_API
extends PlayerEntityMixin_Inventory_API
implements ServerPlayer {
    @Override
    public Optional<Container> getOpenInventory() {
        return Optional.ofNullable((Container)this.openContainer);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory) throws IllegalArgumentException {
        return this.openInventory(inventory, null);
    }

    @Override
    public Optional<Container> openInventory(Inventory inventory, Component displayName) {
        ContainerBridge openContainer = (ContainerBridge)this.openContainer;
        if (openContainer.bridge$isInUse()) {
            Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
            SpongeCommon.getLogger().warn("This player is currently modifying an open container. This action will be delayed.");
            Task.builder().delay(Ticks.zero()).execute(() -> {
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    cause.all().forEach(frame::pushCause);
                    cause.getContext().asMap().forEach((key, value) -> frame.addContext(key, value));
                    this.closeInventory();
                    this.openInventory(inventory);
                }
            }).plugin(((Launch)Launch.getInstance()).getCommonPlugin()).build();
            return this.getOpenInventory();
        }
        return Optional.ofNullable((Container)InventoryEventFactory.displayContainer((ServerPlayerEntity)this, inventory, displayName));
    }

    @Override
    public boolean closeInventory() throws IllegalArgumentException {
        net.minecraft.inventory.container.Container openContainer = this.openContainer;
        if (((ContainerBridge)openContainer).bridge$isInUse()) {
            Cause cause = PhaseTracker.getCauseStackManager().getCurrentCause();
            SpongeCommon.getLogger().warn("This player is currently modifying an open container. This action will be delayed.");
            Task.builder().delay(Ticks.zero()).execute(() -> {
                try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                    cause.all().forEach(frame::pushCause);
                    cause.getContext().asMap().forEach((key, value) -> frame.addContext(key, value));
                    this.closeInventory();
                }
            }).plugin(((Launch)Launch.getInstance()).getCommonPlugin()).build();
            return false;
        }
        try (BasicPacketContext ctx = ((BasicPacketContext)((BasicPacketContext)PacketPhase.General.CLOSE_WINDOW.createPhaseContext(PhaseTracker.SERVER).source(this)).packetPlayer((ServerPlayerEntity)this)).openContainer(openContainer);){
            ctx.buildAndSwitch();
            PlayerInventory inventory = this.inventory;
            ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(inventory.getItemStack());
            boolean bl = !SpongeCommonEventFactory.callInteractInventoryCloseEvent(openContainer, (ServerPlayerEntity)this, cursor, cursor, false).isCancelled();
            return bl;
        }
    }
}

