/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.entity;

import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;

@Mixin(value={Entity.class}, priority=1500)
public abstract class EntityMixin_Optimization_Collision {
    @Inject(method={"doBlockCollisions"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$checkForNeighboringChunkIfAvailable(CallbackInfo ci) {
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || !activeChunk.bridge$areNeighborsLoaded() || activeChunk.bridge$isQueuedForUnload()) {
            ci.cancel();
        }
    }

    @Redirect(method={"doBlockCollisions"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean activeCollision$ignoreWorldIsAreaLoaded(World world, BlockPos from, BlockPos to) {
        return true;
    }

    @Inject(method={"handleFluidAcceleration"}, at={@At(value="HEAD")}, cancellable=true)
    private void activeCollision$BailIfNeighborsAreInactive(Tag<Fluid> p_210500_1_, CallbackInfoReturnable<Boolean> cir) {
        ChunkBridge activeChunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (activeChunk == null || activeChunk.bridge$isQueuedForUnload() || !activeChunk.bridge$areNeighborsLoaded()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"handleFluidAcceleration"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(IIIIII)Z"))
    private boolean activeCollision$IgnoreAreaIsLoaded(World world, int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd) {
        if (((WorldBridge)world).bridge$isFake()) {
            return world.isAreaLoaded(xStart, yStart, zStart, xEnd, yEnd, zEnd);
        }
        return true;
    }
}

