/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.tileentity;

import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.core.tileentity.LockableLootTileEntityMixin;

@Mixin(value={ChestTileEntity.class})
public abstract class ChestTileEntityMixin_Optimization_TileEntity
extends LockableLootTileEntityMixin {
    @Shadow
    protected float lidAngle;
    @Shadow
    protected int numPlayersUsing;
    @Shadow
    private int ticksSinceSync;
    @Shadow
    protected float prevLidAngle;

    @Shadow
    protected abstract void shadow$playSound(SoundEvent var1);

    @Shadow
    public static int shadow$calculatePlayersUsingSync(World p_213977_0_, LockableTileEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        throw new UnsupportedOperationException("Shadowed calculatePlayersUsingSync");
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$DisableTickingChestsOnServer(CallbackInfo ci) {
        ++this.ticksSinceSync;
        ci.cancel();
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onPlaySound(SoundEvent soundIn, CallbackInfo ci) {
        if (!this.shadow$getBlockState().has((IProperty)ChestBlock.TYPE)) {
            ci.cancel();
        }
    }

    @Inject(method={"openInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/ChestTileEntity;onOpenOrClose()V")})
    private void impl$onOpenInventory(PlayerEntity player, CallbackInfo ci) {
        this.impl$doOpenLogic();
    }

    @Inject(method={"closeInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/ChestTileEntity;onOpenOrClose()V")})
    private void impl$onCloseInventory(PlayerEntity player, CallbackInfo ci) {
        this.impl$doCloseLogic();
    }

    private void impl$doOpenLogic() {
        int i = this.pos.getX();
        int j = this.pos.getY();
        int k = this.pos.getZ();
        this.numPlayersUsing = ChestTileEntityMixin_Optimization_TileEntity.shadow$calculatePlayersUsingSync(this.world, (LockableTileEntity)this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.shadow$playSound(SoundEvents.BLOCK_CHEST_OPEN);
        }
    }

    private void impl$doCloseLogic() {
        if (this.numPlayersUsing == 0) {
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f2 = 0.5f;
            if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                this.shadow$playSound(SoundEvents.BLOCK_CHEST_CLOSE);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }
}

