/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.tileentity;

import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.EnderChestTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.mixin.core.tileentity.TileEntityMixin;

@Mixin(value={EnderChestTileEntity.class})
public abstract class EnderChestTileEntityMixin_Optimization_TileEntity
extends TileEntityMixin {
    @Shadow
    public float lidAngle;
    @Shadow
    public int numPlayersUsing;
    @Shadow
    public float prevLidAngle;
    @Shadow
    private int ticksSinceSync;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreTicking(CallbackInfo ci) {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.world.addBlockEvent(this.pos, Blocks.ENDER_CHEST, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        ci.cancel();
    }

    @Inject(method={"openChest"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addBlockEvent(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;II)V")})
    private void impl$onOpenChest(CallbackInfo ci) {
        this.impl$doOpenLogic();
    }

    @Inject(method={"closeChest"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addBlockEvent(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;II)V")})
    private void impl$onCloseChest(CallbackInfo ci) {
        this.impl$doCloseLogic();
    }

    private void impl$doOpenLogic() {
        int i = this.pos.getX();
        int j = this.pos.getY();
        int k = this.pos.getZ();
        float f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d0 = (double)i + 0.5;
            double d1 = (double)k + 0.5;
            this.world.playSound((PlayerEntity)null, d0, (double)j + 0.5, d1, SoundEvents.BLOCK_ENDER_CHEST_OPEN, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
        }
    }

    private void impl$doCloseLogic() {
        int i = this.pos.getX();
        int j = this.pos.getY();
        int k = this.pos.getZ();
        if (this.numPlayersUsing == 0) {
            double d3 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.world.playSound((PlayerEntity)null, d3, (double)j + 0.5, d2, SoundEvents.BLOCK_ENDER_CHEST_CLOSE, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }
}

