/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.optimization.mcp.world;

import net.minecraft.block.BlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.IBlockReaderBridge;

@Mixin(value={IBlockReader.class}, priority=1500)
public interface IBlockReaderMixin_RayTraceChunkLoadOptimizations {
    @Shadow
    public BlockState shadow$getBlockState(BlockPos var1);

    @Shadow
    public IFluidState shadow$getFluidState(BlockPos var1);

    @Shadow
    public BlockRayTraceResult shadow$rayTraceBlocks(Vec3d var1, Vec3d var2, BlockPos var3, VoxelShape var4, BlockState var5);

    @Overwrite
    default public BlockRayTraceResult rayTraceBlocks(RayTraceContext context) {
        return (BlockRayTraceResult)IBlockReader.doRayTrace((RayTraceContext)context, (p_217297_1_, p_217297_2_) -> {
            @Nullable BlockState blockstate = ((IBlockReaderBridge)((Object)this)).bridge$getBlockIfLoaded((BlockPos)p_217297_2_);
            if (blockstate == null) {
                Vec3d vec3d = p_217297_1_.getStartVec().subtract(p_217297_1_.getEndVec());
                return BlockRayTraceResult.createMiss((Vec3d)context.getEndVec(), (Direction)Direction.getFacingFromVector((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)new BlockPos(p_217297_1_.getEndVec()));
            }
            IFluidState ifluidstate = this.shadow$getFluidState((BlockPos)p_217297_2_);
            Vec3d vec3d = p_217297_1_.getStartVec();
            Vec3d vec3d1 = p_217297_1_.getEndVec();
            VoxelShape voxelshape = p_217297_1_.getBlockShape(blockstate, (IBlockReader)this, p_217297_2_);
            BlockRayTraceResult blockraytraceresult = this.shadow$rayTraceBlocks(vec3d, vec3d1, (BlockPos)p_217297_2_, voxelshape, blockstate);
            VoxelShape voxelshape1 = p_217297_1_.getFluidShape(ifluidstate, (IBlockReader)this, p_217297_2_);
            BlockRayTraceResult blockraytraceresult1 = voxelshape1.rayTrace(vec3d, vec3d1, p_217297_2_);
            double d0 = blockraytraceresult == null ? Double.MAX_VALUE : p_217297_1_.getStartVec().squareDistanceTo(blockraytraceresult.getHitVec());
            double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : p_217297_1_.getStartVec().squareDistanceTo(blockraytraceresult1.getHitVec());
            return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
        }, p_217302_0_ -> {
            Vec3d vec3d = p_217302_0_.getStartVec().subtract(p_217302_0_.getEndVec());
            return BlockRayTraceResult.createMiss((Vec3d)p_217302_0_.getEndVec(), (Direction)Direction.getFacingFromVector((double)vec3d.x, (double)vec3d.y, (double)vec3d.z), (BlockPos)new BlockPos(p_217302_0_.getEndVec()));
        });
    }
}

