/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.entity;

import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.WorldBridge;

@Mixin(value={Entity.class})
public abstract class EntityMixin_RealTime {
    @Shadow
    protected int rideCooldown;
    @Shadow
    public World world;
    @Shadow
    protected int portalCounter;
    @Shadow
    public int timeUntilPortal;

    @Redirect(method={"baseTick"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;rideCooldown:I", opcode=181), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;stopRiding()V"), to=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;distanceWalkedModified:F", opcode=180)))
    private void realTimeImpl$adjustForRealTimeEntityCooldown(Entity self, int modifier) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.rideCooldown = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.world).realTimeBridge$getRealTimeTicks();
        this.rideCooldown = Math.max(0, this.rideCooldown - ticks);
    }

    @Redirect(method={"updatePortal"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;portalCounter:I", opcode=181, ordinal=0), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getMaxInPortalTime()I"), to=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;getPortalCooldown()I")))
    private void realTimeImpl$adjustForRealTimePortalCounter(Entity self, int modifier) {
        if (((WorldBridge)this.world).bridge$isFake()) {
            this.portalCounter = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.world).realTimeBridge$getRealTimeTicks();
        this.portalCounter += ticks;
    }
}

