/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.realtime.network.play;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.RealTimeTrackingBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.hooks.SpongeImplHooks;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin_RealTime {
    @Shadow
    private int chatSpamThresholdCount;
    @Shadow
    private int itemDropThreshold;
    @Shadow
    @Final
    private MinecraftServer server;
    @Shadow
    public ServerPlayerEntity player;

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/network/play/ServerPlayNetHandler;chatSpamThresholdCount:I", opcode=181, ordinal=0))
    private void realTimeImpl$adjustForRealTimeChatSpamCheck(ServerPlayNetHandler self, int modifier) {
        if (SpongeImplHooks.isFakePlayer((Entity)this.player) || ((WorldBridge)this.player.world).bridge$isFake()) {
            this.chatSpamThresholdCount = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.server).realTimeBridge$getRealTimeTicks();
        this.chatSpamThresholdCount = Math.max(0, this.chatSpamThresholdCount - ticks);
    }

    @Redirect(method={"tick"}, at=@At(value="FIELD", target="Lnet/minecraft/network/play/ServerPlayNetHandler;itemDropThreshold:I", opcode=181, ordinal=0))
    private void realTimeImpl$adjustForRealTimeDropSpamCheck(ServerPlayNetHandler self, int modifier) {
        if (SpongeImplHooks.isFakePlayer((Entity)this.player) || ((WorldBridge)this.player.world).bridge$isFake()) {
            this.itemDropThreshold = modifier;
            return;
        }
        int ticks = (int)((RealTimeTrackingBridge)this.server).realTimeBridge$getRealTimeTicks();
        this.itemDropThreshold = Math.max(0, this.itemDropThreshold - ticks);
    }
}

