/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.block;

import java.util.Random;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.mixin.tracker.block.BlockMixin_Tracker;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesBlockMixin_Tracker
extends BlockMixin_Tracker {
    @Shadow
    @Final
    public static BooleanProperty PERSISTENT;
    @Shadow
    @Final
    public static IntegerProperty DISTANCE;

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    private boolean tracker$switchContextForDecay(net.minecraft.world.server.ServerWorld serverWorld, BlockPos pos, net.minecraft.block.BlockState newState, int flags) {
        PhaseTracker instance = PhaseTracker.getInstance();
        PhaseContext<?> currentContext = instance.getPhaseContext();
        IPhaseState currentState = currentContext.state;
        try (PhaseContext context = currentState.includesDecays() ? null : ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext(instance)).source(new SpongeLocatableBlockBuilder().world((ServerWorld)serverWorld).position(pos.getX(), pos.getY(), pos.getZ()).state((BlockState)newState).build());){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = serverWorld.setBlockState(pos, newState, flags);
            return bl;
        }
    }

    @Overwrite
    public void randomTick(net.minecraft.block.BlockState state, net.minecraft.world.server.ServerWorld worldIn, BlockPos pos, Random random) {
        if (!((Boolean)state.get((IProperty)PERSISTENT)).booleanValue() && (Integer)state.get((IProperty)DISTANCE) == 7) {
            if (!((WorldBridge)worldIn).bridge$isFake()) {
                PhaseContext<?> peek = PhaseTracker.getInstance().getPhaseContext();
                IPhaseState currentState = peek.state;
                try (PhaseContext context = currentState.includesDecays() ? null : ((PhaseContext)BlockPhase.State.BLOCK_DECAY.createPhaseContext(PhaseTracker.SERVER)).source(new SpongeLocatableBlockBuilder().world((ServerWorld)worldIn).position(pos.getX(), pos.getY(), pos.getZ()).state((BlockState)state).build());){
                    if (context != null) {
                        context.buildAndSwitch();
                    }
                    LeavesBlockMixin_Tracker.shadow$spawnDrops(state, (World)worldIn, pos);
                    worldIn.removeBlock(pos, false);
                }
                return;
            }
            LeavesBlockMixin_Tracker.shadow$spawnDrops(state, (World)worldIn, pos);
            worldIn.removeBlock(pos, false);
        }
    }
}

