/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.entity.item;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin_Tracker
extends Entity {
    public FallingBlockEntityMixin_Tracker(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void tracker$handleBlockCapture(CallbackInfo ci) {
        BlockPos pos = new BlockPos((Entity)((FallingBlockEntity)this));
        if (((WorldBridge)this.world).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT) {
            return;
        }
        PhaseContext<?> currentContext = PhaseTracker.getInstance().getPhaseContext();
        if (currentContext.state.doesBlockEventTracking(currentContext)) {
            if (!TrackingUtil.processBlockCaptures(currentContext)) {
                this.remove();
                ci.cancel();
            }
        } else if (this.world.getBlockState(pos) != Blocks.AIR.getDefaultState()) {
            this.remove();
            ci.cancel();
        }
    }
}

