/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.network.play;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.server.management.PlayerInteractionManagerBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.tick.PlayerTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin_Tracker {
    @Shadow
    public ServerPlayerEntity player;

    @Shadow
    public abstract void disconnect(ITextComponent var1);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;playerTick()V"))
    private void tracker$wrapPlayerTickWithPhase(ServerPlayerEntity player) {
        if (SpongeImplHooks.isFakePlayer((Entity)player) || ((WorldBridge)player.world).bridge$isFake()) {
            player.playerTick();
            return;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();
             PlayerTickContext context = (PlayerTickContext)TickPhase.Tick.PLAYER.createPhaseContext(PhaseTracker.SERVER).source(player);){
            context.buildAndSwitch();
            frame.pushCause(player);
            player.playerTick();
        }
    }

    @Redirect(method={"processTryUseItemOnBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerInteractionManager;func_219441_a(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/Hand;Lnet/minecraft/util/math/BlockRayTraceResult;)Lnet/minecraft/util/ActionResultType;"))
    private ActionResultType tracker$checkState(PlayerInteractionManager interactionManager, PlayerEntity playerIn, World worldIn, ItemStack stack, Hand hand, BlockRayTraceResult rayTraceResult) {
        ActionResultType actionResult = interactionManager.func_219441_a((PlayerEntity)this.player, worldIn, stack, hand, rayTraceResult);
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return actionResult;
        }
        PacketContext context = (PacketContext)PhaseTracker.getInstance().getPhaseContext();
        if (!context.getInteractItemChanged()) {
            ItemStack itemStack = ItemStackUtil.toNative(context.getItemUsed());
            boolean isInteractionCancelled = ((PlayerInteractionManagerBridge)this.player.interactionManager).bridge$isInteractBlockRightClickCancelled();
            if (!ItemStack.areItemStacksEqual((ItemStack)itemStack, (ItemStack)this.player.getHeldItem(hand)) && isInteractionCancelled) {
                PacketPhaseUtil.handlePlayerSlotRestore(this.player, itemStack, hand);
            }
        }
        context.interactItemChanged(false);
        ((PlayerInteractionManagerBridge)this.player.interactionManager).bridge$setInteractBlockRightClickCancelled(false);
        return actionResult;
    }

    @Inject(method={"processPlayerDigging"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/play/client/CPlayerDiggingPacket;getPosition()Lnet/minecraft/util/math/BlockPos;")})
    private void tracker$updateLastPrimaryPacket(CPlayerDiggingPacket packetIn, CallbackInfo ci) {
        if (PhaseTracker.getInstance().getPhaseContext().isEmpty()) {
            return;
        }
        SpongeCommonEventFactory.lastPrimaryPacketTick = SpongeCommon.getServer().getTickCounter();
    }
}

