/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.server.dedicated;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={DedicatedServer.class})
public abstract class DedicatedServerMixin_Tracker {
    @Shadow
    public abstract int shadow$getSpawnProtectionSize();

    @Overwrite
    public boolean isBlockProtected(World worldIn, BlockPos pos, PlayerEntity playerIn) {
        IPhaseState<?> phaseState = PhaseTracker.getInstance().getCurrentState();
        if (!phaseState.isInteraction() && SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)worldIn, pos, (Object)playerIn).isCancelled()) {
            return true;
        }
        BlockPos spawnPoint = worldIn.getSpawnPoint();
        int protectionRadius = this.shadow$getSpawnProtectionSize();
        return protectionRadius > 0 && Math.max(Math.abs(pos.getX() - spawnPoint.getX()), Math.abs(pos.getZ() - spawnPoint.getZ())) <= protectionRadius && !((ServerPlayer)playerIn).hasPermission("minecraft.spawn-protection.override");
    }
}

