/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.tracker.world;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.ExplosionBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.transaction.effect.AddBlockLootDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ExplodeBlockEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SpawnDestructBlocksEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.WorldBlockChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.WorldPipeline;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin_Tracker {
    @Shadow
    @Final
    private World world;
    @Shadow
    @Final
    private double x;
    @Shadow
    @Final
    private double y;
    @Shadow
    @Final
    private double z;
    @Shadow
    @Final
    private Explosion.Mode mode;
    @Shadow
    @Final
    private float size;
    @Shadow
    @Final
    private List<BlockPos> affectedBlockPositions;
    @Shadow
    @Final
    private boolean causesFire;
    @Shadow
    @Final
    private Random random;

    @Overwrite
    public void doExplosionB(boolean spawnParticles) {
        boolean flag;
        if (this.world.isRemote) {
            return;
        }
        this.world.playSound(null, this.x, this.y, this.z, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.2f) * 0.7f);
        boolean bl = flag = this.mode != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && (flag || ((ExplosionBridge)((Object)this)).bridge$getShouldDamageBlocks())) {
                if (this.world instanceof ServerWorld) {
                    ((ServerWorld)this.world).spawnParticle((IParticleData)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1, 0.0, 0.0, 0.0, 0.1);
                } else {
                    this.world.addParticle((IParticleData)ParticleTypes.EXPLOSION_EMITTER, this.x, this.y, this.z, 1.0, 0.0, 0.0);
                }
            } else if (this.world instanceof ServerWorld) {
                ((ServerWorld)this.world).spawnParticle((IParticleData)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1, 0.0, 0.0, 0.0, 0.1);
            } else {
                this.world.addParticle((IParticleData)ParticleTypes.EXPLOSION, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            Collections.shuffle(this.affectedBlockPositions, this.world.rand);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.getBlockState(blockpos);
                if (blockstate.isAir()) continue;
                BlockPos blockpos1 = blockpos.toImmutable();
                this.world.getProfiler().startSection("explosion_blocks");
                PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
                ((TrackedWorldBridge)this.world).bridge$startBlockChange(blockpos1, Blocks.AIR.getDefaultState(), 3).ifPresent(builder -> {
                    WorldPipeline build = builder.addEffect(AddBlockLootDropsEffect.getInstance()).addEffect(ExplodeBlockEffect.getInstance()).addEffect(SpawnDestructBlocksEffect.getInstance()).addEffect(WorldBlockChangeCompleteEffect.getInstance()).build();
                    build.processEffects(context, blockstate, Blocks.AIR.getDefaultState(), blockpos1, BlockChangeFlagManager.fromNativeInt(3));
                });
                this.world.getProfiler().endSection();
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos2 : this.affectedBlockPositions) {
                if (this.random.nextInt(3) != 0 || !this.world.getBlockState(blockpos2).isAir() || !this.world.getBlockState(blockpos2.down()).isOpaqueCube((IBlockReader)this.world, blockpos2.down())) continue;
                this.world.setBlockState(blockpos2, Blocks.FIRE.getDefaultState());
            }
        }
    }
}

