/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.channel.packet;

import com.google.common.base.MoreObjects;
import java.util.function.Supplier;
import org.spongepowered.api.network.channel.packet.Packet;
import org.spongepowered.api.network.channel.packet.PacketBinding;
import org.spongepowered.common.network.channel.PacketUtil;

public abstract class SpongePacketBinding<P extends Packet>
implements PacketBinding<P> {
    private final int opcode;
    private final Class<P> packetType;
    private final Supplier<P> constructor;

    public SpongePacketBinding(int opcode, Class<P> packetType) {
        this.opcode = opcode;
        this.packetType = packetType;
        this.constructor = PacketUtil.getConstructor(packetType);
    }

    @Override
    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public Class<P> getPacketType() {
        return this.packetType;
    }

    public Supplier<P> getPacketConstructor() {
        return this.constructor;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("opcode", this.opcode).add("packetType", (Object)this.packetType.getName()).toString();
    }
}

