/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.network.packet;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.dimension.DimensionType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.network.EngineConnectionTypes;
import org.spongepowered.api.network.channel.packet.PacketChannel;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.dimension.DimensionTypeAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.network.packet.ChangeViewerEnvironmentPacket;
import org.spongepowered.common.network.packet.RegisterDimensionTypePacket;
import org.spongepowered.common.network.packet.RequestBlockTrackerDataPacket;
import org.spongepowered.common.network.packet.RequestEntityTrackerDataPacket;
import org.spongepowered.common.network.packet.TrackerDataResponsePacket;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

public final class SpongePacketHandler {
    private static PacketChannel channel;

    public static void init(SpongeChannelRegistry registry) {
        channel = registry.createChannel(ResourceKey.sponge("default"), PacketChannel.class);
        channel.registerTransactional(RequestBlockTrackerDataPacket.class, TrackerDataResponsePacket.class, 0).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.getPlayer();
            if (!player.hasPermission("sponge.debug.block-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            BlockPos pos = new BlockPos(requestPacket.x, requestPacket.y, requestPacket.z);
            if (!sender.world.isBlockLoaded(pos)) {
                return;
            }
            ChunkBridge chunkBridge = (ChunkBridge)sender.world.getChunkAt(pos);
            Optional<User> owner = chunkBridge.bridge$getBlockCreator(pos);
            Optional<User> notifier = chunkBridge.bridge$getBlockNotifier(pos);
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.registerTransactional(RequestEntityTrackerDataPacket.class, TrackerDataResponsePacket.class, 1).setRequestHandler(EngineConnectionTypes.SERVER_PLAYER, (requestPacket, connection, response) -> {
            ServerPlayer player = connection.getPlayer();
            if (!player.hasPermission("sponge.debug.entity-tracking")) {
                return;
            }
            ServerPlayerEntity sender = (ServerPlayerEntity)player;
            Entity entity = sender.world.getEntityByID(requestPacket.entityId);
            if (!(entity instanceof CreatorTrackedBridge)) {
                return;
            }
            CreatorTrackedBridge creatorTrackedBridge = (CreatorTrackedBridge)entity;
            Optional<User> owner = creatorTrackedBridge.tracked$getCreatorReference();
            Optional<User> notifier = creatorTrackedBridge.tracked$getNotifierReference();
            response.success(SpongePacketHandler.createTrackerDataResponse(owner, notifier));
        });
        channel.register(RegisterDimensionTypePacket.class, 2).addHandler(ClientSideConnection.class, (packet, connection) -> {
            if (Registry.DIMENSION_TYPE.containsKey(packet.actualDimension)) {
                return;
            }
            SpongeDimensionType logicType = SpongeCommon.getRegistry().getCatalogRegistry().get(org.spongepowered.api.world.dimension.DimensionType.class, (ResourceKey)packet.dimensionLogic).orElse(null);
            DimensionType registeredType = DimensionTypeAccessor.accessor$construct(packet.dimensionId, "", packet.actualDimension.getPath(), logicType.getDimensionFactory(), logicType.hasSkylight(), (IBiomeMagnifier)(logicType == DimensionTypes.OVERWORLD.get() ? ColumnFuzzedBiomeMagnifier.INSTANCE : FuzzedBiomeMagnifier.INSTANCE));
            DimensionTypeAccessor.accessor$register(packet.actualDimension.toString(), registeredType);
            ((DimensionTypeBridge)registeredType).bridge$setSpongeDimensionType(logicType);
        });
        channel.register(ChangeViewerEnvironmentPacket.class, 3).addHandler(ClientSideConnection.class, (packet, connection) -> {
            ClientWorld world = Minecraft.getInstance().world;
            if (world == null) {
                return;
            }
            SpongeDimensionType dimensionType = SpongeCommon.getRegistry().getCatalogRegistry().get(org.spongepowered.api.world.dimension.DimensionType.class, (ResourceKey)packet.dimensionLogic).orElse(null);
            ((WorldBridge)world).bridge$adjustDimensionLogic(dimensionType);
        });
    }

    private static TrackerDataResponsePacket createTrackerDataResponse(Optional<User> owner, Optional<User> notifier) {
        String ownerName = owner.map(User::getName).orElse("");
        String notifierName = notifier.map(User::getName).orElse("");
        return new TrackerDataResponsePacket(ownerName, notifierName);
    }

    public static PacketChannel getChannel() {
        return Objects.requireNonNull(channel);
    }
}

