/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.FrameType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.ItemTier;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Team;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.state.properties.PistonType;
import net.minecraft.state.properties.RailShape;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.GameType;
import net.minecraft.world.raid.Raid;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Game;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.command.parameter.managed.clientcompletion.ClientCompletionType;
import org.spongepowered.api.command.parameter.managed.standard.CatalogedValueParameter;
import org.spongepowered.api.command.registrar.CommandRegistrar;
import org.spongepowered.api.command.registrar.tree.ClientCompletionKey;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataFormat;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.data.type.ArtType;
import org.spongepowered.api.data.type.AttachmentSurface;
import org.spongepowered.api.data.type.BannerPatternShape;
import org.spongepowered.api.data.type.BoatType;
import org.spongepowered.api.data.type.BodyPart;
import org.spongepowered.api.data.type.CatType;
import org.spongepowered.api.data.type.ChestAttachmentType;
import org.spongepowered.api.data.type.ComparatorMode;
import org.spongepowered.api.data.type.DoorHinge;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.FoxType;
import org.spongepowered.api.data.type.HandPreference;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.InstrumentType;
import org.spongepowered.api.data.type.LlamaType;
import org.spongepowered.api.data.type.MooshroomType;
import org.spongepowered.api.data.type.NotePitch;
import org.spongepowered.api.data.type.PandaGene;
import org.spongepowered.api.data.type.ParrotType;
import org.spongepowered.api.data.type.PhantomPhase;
import org.spongepowered.api.data.type.PickupRule;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.ProfessionType;
import org.spongepowered.api.data.type.RabbitType;
import org.spongepowered.api.data.type.RaidStatus;
import org.spongepowered.api.data.type.RailDirection;
import org.spongepowered.api.data.type.SlabPortion;
import org.spongepowered.api.data.type.SpellType;
import org.spongepowered.api.data.type.StairShape;
import org.spongepowered.api.data.type.ToolType;
import org.spongepowered.api.data.type.TropicalFishShape;
import org.spongepowered.api.data.type.VillagerType;
import org.spongepowered.api.data.type.WireAttachmentType;
import org.spongepowered.api.data.type.WoodType;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.potion.PotionEffectType;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.ai.goal.GoalExecutorType;
import org.spongepowered.api.entity.ai.goal.GoalType;
import org.spongepowered.api.entity.attribute.AttributeOperation;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.cause.entity.DismountType;
import org.spongepowered.api.event.cause.entity.MovementType;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.equipment.EquipmentGroup;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.menu.ClickType;
import org.spongepowered.api.item.inventory.query.QueryType;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.placeholder.PlaceholderParser;
import org.spongepowered.api.registry.CatalogRegistry;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.UnknownTypeException;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.service.ban.BanType;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.account.AccountDeletionResultType;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.common.accessor.util.registry.SimpleRegistryAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.persistence.DataSerializers;
import org.spongepowered.common.data.persistence.HoconDataFormat;
import org.spongepowered.common.data.persistence.JsonDataFormat;
import org.spongepowered.common.data.persistence.NbtDataFormat;
import org.spongepowered.common.event.lifecycle.RegisterCatalogEventImpl;
import org.spongepowered.common.event.tracking.context.transaction.type.BlockTransactionTypeStreamGenerator;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.registry.CallbackRegistry;
import org.spongepowered.common.registry.MappedRegistry;
import org.spongepowered.common.registry.builtin.sponge.AccountDeletionResultTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.BanTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.BlockOperationStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.BodyPartStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.CatTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.CatalogedValueParameterStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.ClickTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.ClientCompletionKeyStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.ClientCompletionTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.CommandRegistrarStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.CriteriaTriggersRegistrar;
import org.spongepowered.common.registry.builtin.sponge.CriterionStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.DamageModifierTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.DamageTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.DimensionTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.DismountTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.DisplaySlotStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.EquipmentGroupStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.EquipmentTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.EventContextKeyStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.FireworkShapeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.GeneratorModifierTypeRegistrar;
import org.spongepowered.common.registry.builtin.sponge.GoalExecutorTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.GoalTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.HorseColorStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.HorseStyleStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.IAttributeTypeRegistrar;
import org.spongepowered.common.registry.builtin.sponge.KeyStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.LlamaTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.MovementTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.MusicDiscStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.NotePitchStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.PaletteTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.ParrotTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.ParticleOptionStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.PhaseTypeRegistrar;
import org.spongepowered.common.registry.builtin.sponge.PlaceholderParserStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.PortalTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.QueryTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.RabbitTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.SelectorSortAlgorithmStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.SelectorTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.SpawnTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.TeleportHelperFilterStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.WeatherStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.WoodTypeStreamGenerator;
import org.spongepowered.common.registry.builtin.sponge.WorldArchetypeStreamGenerator;
import org.spongepowered.common.registry.builtin.vanilla.BiomeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.BlockSupplier;
import org.spongepowered.common.registry.builtin.vanilla.ContainerTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.EffectSupplier;
import org.spongepowered.common.registry.builtin.vanilla.EnchantmentSupplier;
import org.spongepowered.common.registry.builtin.vanilla.EntityTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.FluidSupplier;
import org.spongepowered.common.registry.builtin.vanilla.ItemSupplier;
import org.spongepowered.common.registry.builtin.vanilla.PaintingTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.ParticleTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.RecipeTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.SoundEventSupplier;
import org.spongepowered.common.registry.builtin.vanilla.TileEntityTypeSupplier;
import org.spongepowered.common.registry.builtin.vanilla.VillagerProfessionSupplier;
import org.spongepowered.common.registry.builtin.vanilla.VillagerTypeSupplier;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

@Singleton
public final class SpongeCatalogRegistry
implements CatalogRegistry {
    private final Map<Class<CatalogType>, Map<String, Supplier<CatalogType>>> suppliers = new IdentityHashMap<Class<CatalogType>, Map<String, Supplier<CatalogType>>>();
    private final Map<ResourceKey, Registry<CatalogType>> registries = new Object2ObjectOpenHashMap();
    private final Map<Class<CatalogType>, Registry<CatalogType>> registriesByType = new IdentityHashMap<Class<CatalogType>, Registry<CatalogType>>();
    private final List<Class<? extends CatalogType>> dynamicCatalogs = new ArrayList<Class<? extends CatalogType>>();
    private final List<Class<? extends CatalogType>> datapackCatalogues = new ArrayList<Class<? extends CatalogType>>();

    @Override
    public <T extends CatalogType, E extends T> Supplier<E> provideSupplier(Class<T> catalogClass, String suggestedId) {
        Objects.requireNonNull(suggestedId);
        Map<String, Supplier<CatalogType>> catalogSuppliers = this.suppliers.get(catalogClass);
        if (catalogSuppliers == null) {
            String message = String.format("No suppliers found for type '%s'!", catalogClass);
            System.err.println(message);
            throw new UnknownTypeException(message);
        }
        Supplier<CatalogType> catalogSupplier = catalogSuppliers.get(suggestedId.toLowerCase());
        if (catalogSupplier == null) {
            String message = String.format("Supplier for type '%s' with id '%s' has not been registered!", catalogClass, suggestedId);
            System.err.println(message);
            throw new UnknownTypeException(message);
        }
        return catalogSupplier;
    }

    @Override
    public <T extends CatalogType> Optional<T> get(Class<T> typeClass, net.kyori.adventure.key.Key key) {
        Objects.requireNonNull(key);
        Registry<CatalogType> registry = this.registriesByType.get(typeClass);
        if (registry == null) {
            return Optional.empty();
        }
        return registry.getValue(SpongeAdventure.asVanilla(key));
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllOf(Class<T> typeClass) {
        Registry<CatalogType> registry = this.registriesByType.get(typeClass);
        if (registry == null) {
            return Collections.emptyList();
        }
        return ImmutableSet.copyOf((Collection)((SimpleRegistryAccessor)registry).accessor$getRegistryObjects().values());
    }

    @Override
    public <T extends CatalogType> Stream<T> streamAllOf(Class<T> typeClass) {
        Registry<CatalogType> registry = this.registriesByType.get(typeClass);
        Stream<Object> stream = registry == null ? Stream.empty() : ((SimpleRegistryAccessor)registry).accessor$getRegistryObjects().values().stream();
        return stream;
    }

    @Override
    public <T extends CatalogType> Collection<T> getAllFor(Class<T> typeClass, String namespace) {
        Objects.requireNonNull(namespace);
        Registry<CatalogType> registry = this.registriesByType.get(typeClass);
        ArrayList<CatalogType> types = new ArrayList<CatalogType>();
        for (Map.Entry entry : ((SimpleRegistryAccessor)registry).accessor$getRegistryObjects().entrySet()) {
            if (!((ResourceLocation)entry.getKey()).getNamespace().equals(namespace)) continue;
            types.add((CatalogType)entry.getValue());
        }
        return types;
    }

    @Override
    public <T extends CatalogType> Stream<T> streamAllFor(Class<T> typeClass, String namespace) {
        Objects.requireNonNull(namespace);
        Registry<CatalogType> registry = this.registriesByType.get(typeClass);
        Stream<Object> stream = registry == null ? Stream.empty() : ((SimpleRegistryAccessor)registry).accessor$getRegistryObjects().entrySet().stream().filter(kv -> ((ResourceLocation)kv.getKey()).getNamespace().equals(namespace)).map(Map.Entry::getValue);
        return stream;
    }

    public <T extends CatalogType, E extends T> SpongeCatalogRegistry registerCatalogAndSupplier(Class<E> catalogClass, String suggestedId, Supplier<E> supplier) {
        Objects.requireNonNull(supplier);
        CatalogType value = (CatalogType)supplier.get();
        Registry<CatalogType> registry = this.registriesByType.get(catalogClass);
        ((SimpleRegistry)registry).register((ResourceLocation)value.getKey(), (Object)value);
        return this.registerSupplier(catalogClass, suggestedId, supplier);
    }

    public <T extends CatalogType, E extends T> SpongeCatalogRegistry registerSupplier(Class<E> catalogClass, String suggestedId, Supplier<E> supplier) {
        Objects.requireNonNull(supplier);
        Map catalogSuppliers = this.suppliers.computeIfAbsent(catalogClass, k -> new Object2ObjectArrayMap());
        if (catalogSuppliers.containsKey(suggestedId)) {
            throw new DuplicateRegistrationException(String.format("Catalog '%s' with id '%s' has a supplier already registered!", catalogClass, suggestedId));
        }
        catalogSuppliers.put(suggestedId, supplier);
        return this;
    }

    public <T extends CatalogType> SpongeCatalogRegistry registerRegistry(Class<T> catalogClass, ResourceKey key, boolean isDynamic, boolean isDataPack) {
        return this.registerRegistry(catalogClass, key, null, false, isDynamic, isDataPack);
    }

    public <T extends CatalogType> SpongeCatalogRegistry registerRegistry(Class<T> catalogClass, ResourceKey key, boolean isDynamic) {
        return this.registerRegistry(catalogClass, key, null, false, isDynamic, false);
    }

    public <T extends CatalogType> SpongeCatalogRegistry registerRegistry(Class<T> catalogClass, ResourceKey key, @Nullable Supplier<Set<T>> defaultsSupplier, boolean generateSuppliers, boolean isDynamic, boolean isDataPack) {
        Objects.requireNonNull(key);
        if (isDataPack) {
            this.registries.remove(key);
            this.registriesByType.remove(catalogClass);
        }
        if (this.registries.get(key) != null) {
            throw new DuplicateRegistrationException(String.format("Catalog '%s' already has a registry registered for '%s!", catalogClass, key));
        }
        SimpleRegistry registry = new SimpleRegistry();
        this.registries.put(key, (Registry<CatalogType>)registry);
        this.registriesByType.put(catalogClass, (Registry<CatalogType>)registry);
        if (defaultsSupplier != null) {
            defaultsSupplier.get().forEach(catalogType -> {
                registry.register((ResourceLocation)catalogType.getKey(), catalogType);
                if (generateSuppliers) {
                    this.suppliers.computeIfAbsent(catalogClass, k -> new HashMap()).put(catalogType.getKey().getValue(), () -> catalogType);
                }
            });
        }
        if (isDynamic) {
            if (isDataPack) {
                this.datapackCatalogues.add(catalogClass);
            } else {
                this.dynamicCatalogs.add(catalogClass);
            }
        }
        return this;
    }

    public <T extends CatalogType> SpongeCatalogRegistry registerRegistry(Class<T> catalogClass, ResourceKey key, Registry<T> registry) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(registry);
        this.registries.put(key, registry);
        this.registriesByType.put(catalogClass, registry);
        return this;
    }

    public <T extends CatalogType> SpongeCatalogRegistry registerCallbackRegistry(Class<T> catalogClass, ResourceKey key, @Nullable Supplier<Set<T>> defaultsSupplier, BiConsumer<ResourceLocation, T> callback, boolean generateSuppliers, boolean isDynamic) {
        Objects.requireNonNull(key);
        if (this.registries.containsKey(key)) {
            throw new DuplicateRegistrationException(String.format("Catalog '%s' already has a registry registered for '%s!", catalogClass, key));
        }
        CallbackRegistry registry = new CallbackRegistry(callback);
        this.registries.put(key, (Registry<CatalogType>)registry);
        this.registriesByType.put((Class<CatalogType>)catalogClass, (Registry<CatalogType>)registry);
        if (defaultsSupplier != null) {
            defaultsSupplier.get().forEach(v -> {
                registry.register((ResourceLocation)v.getKey(), v);
                if (generateSuppliers) {
                    this.suppliers.computeIfAbsent(catalogClass, k -> new HashMap()).put(v.getKey().getValue(), () -> v);
                }
            });
        }
        if (isDynamic) {
            this.dynamicCatalogs.add(catalogClass);
        }
        return this;
    }

    private <T extends CatalogType, U> SpongeCatalogRegistry registerMappedRegistry(Class<T> catalogClass, ResourceKey key, @Nullable Supplier<Set<Tuple<T, U>>> defaultsSupplier, boolean generateSuppliers, boolean isDynamic) {
        Objects.requireNonNull(key);
        if (this.registries.containsKey(key)) {
            throw new DuplicateRegistrationException(String.format("Catalog '%s' already has a registry registered for '%s!", catalogClass, key));
        }
        MappedRegistry registry = new MappedRegistry();
        this.registries.put(key, (Registry<CatalogType>)registry);
        this.registriesByType.put((Class<CatalogType>)catalogClass, (Registry<CatalogType>)registry);
        if (defaultsSupplier != null) {
            defaultsSupplier.get().forEach(kv -> {
                registry.register((ResourceLocation)((CatalogType)kv.getFirst()).getKey(), kv.getFirst());
                registry.registerMapping(kv.getFirst(), kv.getSecond());
                if (generateSuppliers) {
                    this.suppliers.computeIfAbsent(catalogClass, k -> new HashMap()).put(((CatalogType)kv.getFirst()).getKey().getValue(), kv::getFirst);
                }
            });
        }
        if (isDynamic) {
            this.dynamicCatalogs.add(catalogClass);
        }
        return this;
    }

    public <T extends CatalogType, R extends Registry<T>> @Nullable R getRegistry(Class<T> catalogClass) {
        return (R)this.registriesByType.get(catalogClass);
    }

    public <T extends CatalogType, R extends Registry<T>> @NonNull R requireRegistry(Class<T> catalogClass) {
        R registry = this.getRegistry(catalogClass);
        if (registry == null) {
            throw new IllegalArgumentException("No registry is registered for " + catalogClass);
        }
        return registry;
    }

    public <C extends CatalogType> C registerCatalog(TypeToken<C> catalog, C catalogType) {
        Objects.requireNonNull(catalogType);
        Registry<CatalogType> registry = this.registriesByType.get(GenericTypeReflector.erase(catalog.getType()));
        if (registry == null) {
            throw new UnknownTypeException(String.format("Catalog '%s' with id '%s' has no registry registered!", catalogType.getClass(), catalogType.getKey()));
        }
        return (C)((CatalogType)((SimpleRegistry)registry).register((ResourceLocation)catalogType.getKey(), catalogType));
    }

    public void callRegisterCatalogEvents(Cause cause, Game game) {
        this.callRegisterCatalogEvents(cause, game, this.dynamicCatalogs);
    }

    public void callDataPackRegisterCatalogEvents(Cause cause, Game game) {
        this.callRegisterCatalogEvents(cause, game, this.datapackCatalogues);
    }

    private void callRegisterCatalogEvents(Cause cause, Game game, List<Class<? extends CatalogType>> catalogs) {
        for (Class<? extends CatalogType> dynamicCatalog : catalogs) {
            TypeToken<? extends CatalogType> token = TypeToken.get(dynamicCatalog);
            game.getEventManager().post(new RegisterCatalogEventImpl<CatalogType>(cause, game, token));
        }
    }

    public void registerDefaultRegistries() {
        this.registerVanillaRegistries();
        this.generateRegistry(AccountDeletionResultType.class, ResourceKey.sponge("account_deletion_result_type"), AccountDeletionResultTypeStreamGenerator.stream(), true, false).generateRegistry(AdvancementType.class, ResourceKey.minecraft("advancement_type"), Arrays.stream(FrameType.values()), true, false).generateRegistry(org.spongepowered.api.data.type.ArmorMaterial.class, ResourceKey.minecraft("armor_material"), Arrays.stream(ArmorMaterial.values()), true, false).generateRegistry(AttachmentSurface.class, ResourceKey.minecraft("attach_face"), Arrays.stream(AttachFace.values()), true, false).generateRegistry(AttributeOperation.class, ResourceKey.minecraft("attribute_operation"), Arrays.stream(AttributeModifier.Operation.values()), true, false).generateRegistry(BanType.class, ResourceKey.minecraft("ban_type"), BanTypeStreamGenerator.stream(), true, false).generateRegistry(BannerPatternShape.class, ResourceKey.minecraft("banner_pattern_shape"), Arrays.stream(BannerPattern.values()), true, false).generateRegistry(BoatType.class, ResourceKey.minecraft("boat_type"), Arrays.stream(BoatEntity.Type.values()), true, false).generateRegistry(BodyPart.class, ResourceKey.minecraft("body_part"), BodyPartStreamGenerator.stream(), true, false).generateRegistry(ChestAttachmentType.class, ResourceKey.minecraft("chest_attachment_type"), Arrays.stream(ChestType.values()), true, false).generateRegistry(ClientCompletionKey.class, ResourceKey.sponge("client_completion_key"), ClientCompletionKeyStreamGenerator.stream(), true, false).generateRegistry(ClientCompletionType.class, ResourceKey.sponge("client_completion_type"), ClientCompletionTypeStreamGenerator.stream(), true, false).generateRegistry(CollisionRule.class, ResourceKey.minecraft("collision_rule"), Arrays.stream(Team.CollisionRule.values()), true, false).generateRegistry(ComparatorMode.class, ResourceKey.minecraft("comparator_mode"), Arrays.stream(net.minecraft.state.properties.ComparatorMode.values()), true, false).generateRegistry(Criterion.class, ResourceKey.sponge("criterion"), CriterionStreamGenerator.stream(), true, false).registerRegistry(Currency.class, ResourceKey.sponge("currency"), true).generateRegistry(DamageModifierType.class, ResourceKey.sponge("damage_modifier_type"), DamageModifierTypeStreamGenerator.stream(), true, true).generateRegistry(DamageType.class, ResourceKey.sponge("damage_type"), DamageTypeStreamGenerator.stream(), true, true).generateCallbackRegistry(DataRegistration.class, ResourceKey.sponge("data_registration"), Stream.empty(), (key, value) -> ((SpongeDataManager)Sponge.getGame().getDataManager()).registerCustomDataRegistration((SpongeDataRegistration)value), false, true).generateRegistry(Difficulty.class, ResourceKey.minecraft("difficulty"), Arrays.stream(net.minecraft.world.Difficulty.values()), true, false).generateCallbackRegistry(DimensionType.class, ResourceKey.minecraft("dimension_type"), DimensionTypeStreamGenerator.stream(), (k, v) -> {
            net.minecraft.world.dimension.DimensionType registrationType = (net.minecraft.world.dimension.DimensionType)Registry.DIMENSION_TYPE.getValue(k).orElseThrow(() -> new RuntimeException(String.format("DimensionType registry mappings mismatch! '%s' is not registered in Vanilla!", k)));
            ((DimensionTypeBridge)registrationType).bridge$setSpongeDimensionType((SpongeDimensionType)v);
        }, true, false).generateRegistry(DismountType.class, ResourceKey.minecraft("dismount_type"), DismountTypeStreamGenerator.stream(), true, false).generateRegistry(DyeColor.class, ResourceKey.minecraft("dye_color"), Arrays.stream(net.minecraft.item.DyeColor.values()), true, false).generateRegistry(CatalogedValueParameter.class, ResourceKey.sponge("value_parameter"), CatalogedValueParameterStreamGenerator.stream(), true, true).generateRegistry(CommandRegistrar.class, ResourceKey.sponge("command_registrar"), CommandRegistrarStreamGenerator.stream(), true, true).generateRegistry(EquipmentGroup.class, ResourceKey.minecraft("equipment_group"), EquipmentGroupStreamGenerator.stream(), true, false).generateRegistry(EquipmentType.class, ResourceKey.minecraft("equipment_type"), EquipmentTypeStreamGenerator.stream(), true, false).generateRegistry(EventContextKey.class, ResourceKey.sponge("event_context_key"), EventContextKeyStreamGenerator.stream(), true, true).generateRegistry(FoxType.class, ResourceKey.minecraft("fox_type"), Arrays.stream(FoxEntity.Type.values()), true, false).generateRegistry(GameMode.class, ResourceKey.minecraft("game_mode"), Arrays.stream(GameType.values()), true, false).generateRegistry(GoalExecutorType.class, ResourceKey.minecraft("goal_executor_type"), GoalExecutorTypeStreamGenerator.stream(), true, false).generateRegistry(HandPreference.class, ResourceKey.minecraft("hand_preference"), Arrays.stream(HandSide.values()), true, false).generateRegistry(HandType.class, ResourceKey.minecraft("hand_type"), Arrays.stream(Hand.values()), true, false).generateRegistry(DoorHinge.class, ResourceKey.minecraft("door_hinge"), Arrays.stream(DoorHingeSide.values()), true, false).generateRegistry(InstrumentType.class, ResourceKey.minecraft("instrument_type"), Arrays.stream(NoteBlockInstrument.values()), true, false).generateRegistry(Key.class, ResourceKey.sponge("key"), KeyStreamGenerator.stream(), true, true).generateRegistry(MooshroomType.class, ResourceKey.minecraft("mooshroom_type"), Arrays.stream(MooshroomEntity.Type.values()), true, false).generateRegistry(MovementType.class, ResourceKey.sponge("movement_type"), MovementTypeStreamGenerator.stream(), true, true).generateRegistry(MusicDisc.class, ResourceKey.minecraft("music_disc"), MusicDiscStreamGenerator.stream(), true, false).generateRegistry(ObjectiveDisplayMode.class, ResourceKey.sponge("objective_display_mode"), Arrays.stream(ScoreCriteria.RenderType.values()), true, false).generateRegistry(PaletteType.class, ResourceKey.sponge("palette"), PaletteTypeStreamGenerator.stream(), true, true).generateRegistry(PandaGene.class, ResourceKey.minecraft("panda_gene"), Arrays.stream(PandaEntity.Type.values()), true, false).generateRegistry(ParticleOption.class, ResourceKey.sponge("particle_option"), ParticleOptionStreamGenerator.stream(), true, false).generateRegistry(PhantomPhase.class, ResourceKey.minecraft("phantom_phase"), Arrays.stream(PhantomEntity.AttackPhase.values()), true, false).generateRegistry(PickupRule.class, ResourceKey.minecraft("pickup_rule"), Arrays.stream(AbstractArrowEntity.PickupStatus.values()), true, false).generateRegistry(org.spongepowered.api.data.type.PistonType.class, ResourceKey.minecraft("piston_type"), Arrays.stream(PistonType.values()), true, false).generateRegistry(PlaceholderParser.class, ResourceKey.sponge("placeholder"), PlaceholderParserStreamGenerator.stream(), true, true).generateRegistry(PortalType.class, ResourceKey.minecraft("portal_type"), PortalTypeStreamGenerator.stream(), true, true).generateRegistry(PortionType.class, ResourceKey.minecraft("portion_type"), Arrays.stream(Half.values()), true, false).generateRegistry(QueryType.class, ResourceKey.sponge("query_type"), QueryTypeStreamGenerator.stream(), true, true).generateRegistry(RaidStatus.class, ResourceKey.minecraft("raid_status"), Arrays.stream(Raid.Status.values()), true, false).generateRegistry(RailDirection.class, ResourceKey.minecraft("rail_direction"), Arrays.stream(RailShape.values()), true, false).generateRegistry(SelectorSortAlgorithm.class, ResourceKey.minecraft("selector_sort_algorithm"), SelectorSortAlgorithmStreamGenerator.stream(), true, false).generateRegistry(SelectorType.class, ResourceKey.minecraft("selector_type"), SelectorTypeStreamGenerator.stream(), true, false).generateRegistry(SlabPortion.class, ResourceKey.minecraft("slab_portion"), Arrays.stream(SlabType.values()), true, false).generateRegistry(SpawnType.class, ResourceKey.sponge("spawn_type"), SpawnTypeStreamGenerator.stream(), true, true).generateRegistry(SpellType.class, ResourceKey.minecraft("spell_type"), Arrays.stream(SpellcastingIllagerEntity.SpellType.values()), true, false).generateRegistry(StairShape.class, ResourceKey.minecraft("stair_shape"), Arrays.stream(StairsShape.values()), true, false).generateRegistry(org.spongepowered.api.data.type.StructureMode.class, ResourceKey.minecraft("structure_mode"), Arrays.stream(StructureMode.values()), true, false).generateRegistry(ToolType.class, ResourceKey.minecraft("tool_type"), Arrays.stream(ItemTier.values()), true, false).generateRegistry(TropicalFishShape.class, ResourceKey.minecraft("tropical_fish_shape"), Arrays.stream(TropicalFishEntity.Type.values()), true, false).generateRegistry(Weather.class, ResourceKey.minecraft("weather"), WeatherStreamGenerator.stream(), true, false).generateRegistry(WireAttachmentType.class, ResourceKey.minecraft("wire_attachment_type"), Arrays.stream(RedstoneSide.values()), true, false).generateRegistry(WoodType.class, ResourceKey.minecraft("wood_type"), WoodTypeStreamGenerator.stream(), true, false).generateRegistry(WorldArchetype.class, ResourceKey.minecraft("world_archetype"), WorldArchetypeStreamGenerator.stream(), true, true).generateRegistry(Visibility.class, ResourceKey.minecraft("visibility"), Arrays.stream(Team.Visible.values()), true, false).generateRegistry(ClickType.class, ResourceKey.minecraft("click_type"), ClickTypeStreamGenerator.stream(), true, false).generateRegistry(StringDataFormat.class, ResourceKey.sponge("string_data_format"), Stream.of(new JsonDataFormat(ResourceKey.sponge("json")), new HoconDataFormat(ResourceKey.sponge("hocon"))), true, false).generateRegistry(DataFormat.class, ResourceKey.sponge("data_format"), Stream.of(new NbtDataFormat(ResourceKey.sponge("nbt"))), true, false).generateRegistry(TeleportHelperFilter.class, ResourceKey.sponge("teleport_helper_filter"), TeleportHelperFilterStreamGenerator.stream(), true, false).generateRegistry(Operation.class, ResourceKey.sponge("block_operation"), BlockOperationStreamGenerator.stream(), true, false).generateRegistry(TransactionType.class, ResourceKey.sponge("transaction_type"), BlockTransactionTypeStreamGenerator.stream(), true, false);
        this.generateMappedRegistry(CatType.class, ResourceKey.minecraft("cat_type"), CatTypeStreamGenerator.stream(), true, false).generateMappedRegistry(FireworkShape.class, ResourceKey.minecraft("firework_shape"), FireworkShapeStreamGenerator.stream(), true, false).generateMappedRegistry(GoalType.class, ResourceKey.minecraft("goal_type"), GoalTypeStreamGenerator.stream(), true, false).generateMappedRegistry(HorseColor.class, ResourceKey.minecraft("horse_color"), HorseColorStreamGenerator.stream(), true, false).generateMappedRegistry(HorseStyle.class, ResourceKey.minecraft("horse_style"), HorseStyleStreamGenerator.stream(), true, false).generateMappedRegistry(LlamaType.class, ResourceKey.minecraft("llama_type"), LlamaTypeStreamGenerator.stream(), true, false).generateMappedRegistry(NotePitch.class, ResourceKey.minecraft("note_pitch"), NotePitchStreamGenerator.stream(), true, false).generateMappedRegistry(ParrotType.class, ResourceKey.minecraft("parrot_type"), ParrotTypeStreamGenerator.stream(), true, false).generateMappedRegistry(RabbitType.class, ResourceKey.minecraft("rabbit_type"), RabbitTypeStreamGenerator.stream(), true, false).generateMappedRegistry(DataTranslator.class, ResourceKey.sponge("data_translator"), DataSerializers.stream(), true, false).generateMappedRegistry(DisplaySlot.class, ResourceKey.sponge("display_slot"), DisplaySlotStreamGenerator.stream(), true, false);
        this.registerRegistry((Class)SpongeDataRegistration.class, ResourceKey.sponge("data_registration"), (Registry)this.getRegistry(DataRegistration.class));
        this.registerDatapackCatalogues();
    }

    public void registerDatapackCatalogues() {
        this.datapackCatalogues.clear();
        this.registerRegistry(RecipeRegistration.class, ResourceKey.sponge("recipe"), true, true).registerRegistry(Advancement.class, ResourceKey.minecraft("advancement"), true, true);
    }

    private void registerVanillaRegistries() {
        this.registerRegistry(BiomeType.class, ResourceKey.minecraft("biome_type"), Registry.BIOME).registerRegistry(BlockType.class, ResourceKey.minecraft("block_type"), (Registry)Registry.BLOCK).registerRegistry(ItemType.class, ResourceKey.minecraft("item_type"), (Registry)Registry.ITEM).registerRegistry(ContainerType.class, ResourceKey.minecraft("container_type"), Registry.MENU).registerRegistry(PotionEffectType.class, ResourceKey.minecraft("potion_effect_type"), Registry.EFFECTS).registerRegistry(EnchantmentType.class, ResourceKey.minecraft("enchantment_type"), Registry.ENCHANTMENT).registerRegistry(EntityType.class, ResourceKey.minecraft("entity_type"), (Registry)Registry.ENTITY_TYPE).registerRegistry(FluidType.class, ResourceKey.minecraft("fluid_type"), (Registry)Registry.FLUID).registerRegistry(ArtType.class, ResourceKey.minecraft("art_type"), (Registry)Registry.MOTIVE).registerRegistry(ParticleType.class, ResourceKey.minecraft("particle_type"), Registry.PARTICLE_TYPE).registerRegistry(SoundType.class, ResourceKey.minecraft("sound_type"), Registry.SOUND_EVENT).registerRegistry(BlockEntityType.class, ResourceKey.minecraft("block_entity_type"), Registry.BLOCK_ENTITY_TYPE).registerRegistry(ProfessionType.class, ResourceKey.minecraft("profession_type"), (Registry)Registry.VILLAGER_PROFESSION).registerRegistry(VillagerType.class, ResourceKey.minecraft("villager_type"), (Registry)Registry.VILLAGER_TYPE).registerRegistry(RecipeType.class, ResourceKey.minecraft("recipe_type"), Registry.RECIPE_TYPE);
        CriteriaTriggersRegistrar.registerRegistry(this);
        GeneratorModifierTypeRegistrar.registerRegistry(this);
        IAttributeTypeRegistrar.registerRegistry(this);
        PhaseTypeRegistrar.registerRegistry(this);
    }

    public void registerDefaultSuppliers() {
        BiomeSupplier.registerSuppliers(this);
        BlockSupplier.registerSuppliers(this);
        ContainerTypeSupplier.registerSuppliers(this);
        CriteriaTriggersRegistrar.registerSuppliers(this);
        EffectSupplier.registerSuppliers(this);
        EnchantmentSupplier.registerSuppliers(this);
        EntityTypeSupplier.registerSuppliers(this);
        FluidSupplier.registerSuppliers(this);
        GeneratorModifierTypeRegistrar.registerSuppliers(this);
        IAttributeTypeRegistrar.registerSuppliers(this);
        ItemSupplier.registerSuppliers(this);
        PaintingTypeSupplier.registerSuppliers(this);
        ParticleTypeSupplier.registerSuppliers(this);
        PhaseTypeRegistrar.registerSuppliers(this);
        SoundEventSupplier.registerSuppliers(this);
        TileEntityTypeSupplier.registerSuppliers(this);
        VillagerProfessionSupplier.registerSuppliers(this);
        VillagerTypeSupplier.registerSuppliers(this);
        RecipeTypeSupplier.registerSuppliers(this);
    }

    public <T extends CatalogType, E> SpongeCatalogRegistry generateRegistry(Class<T> catalogClass, ResourceKey key, Stream<E> valueStream, boolean generateSuppliers, boolean isDynamic) {
        this.registerRegistry(catalogClass, key, () -> valueStream.map(value -> (CatalogType)value).collect(Collectors.toSet()), generateSuppliers, isDynamic, false);
        return this;
    }

    private <T extends CatalogType, E> SpongeCatalogRegistry generateCallbackRegistry(Class<T> catalogClass, ResourceKey key, Stream<E> valueStream, BiConsumer<ResourceLocation, T> callback, boolean generateSuppliers, boolean isDynamic) {
        this.registerCallbackRegistry(catalogClass, key, () -> valueStream.map(value -> (CatalogType)value).collect(Collectors.toSet()), callback, generateSuppliers, isDynamic);
        return this;
    }

    private <T extends CatalogType, E> SpongeCatalogRegistry generateMappedRegistry(Class<T> catalogClass, ResourceKey key, Stream<Tuple<T, E>> valueStream, boolean generateSuppliers, boolean isDynamic) {
        this.registerMappedRegistry(catalogClass, key, () -> valueStream.collect(Collectors.toSet()), generateSuppliers, isDynamic);
        return this;
    }
}

