/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.AdventureRegistry;
import org.spongepowered.api.item.merchant.VillagerRegistry;
import org.spongepowered.api.item.recipe.RecipeRegistry;
import org.spongepowered.api.registry.FactoryRegistry;
import org.spongepowered.api.registry.GameRegistry;
import org.spongepowered.common.adventure.AdventureRegistryImpl;
import org.spongepowered.common.registry.SpongeBuilderRegistry;
import org.spongepowered.common.registry.SpongeCatalogRegistry;
import org.spongepowered.common.registry.SpongeFactoryRegistry;
import org.spongepowered.common.registry.SpongeVillagerRegistry;

@Singleton
public final class SpongeGameRegistry
implements GameRegistry {
    private final SpongeCatalogRegistry catalogRegistry;
    private final SpongeBuilderRegistry builderRegistry;
    private final SpongeFactoryRegistry factoryRegistry;

    @Inject
    public SpongeGameRegistry(SpongeCatalogRegistry catalogRegistry, SpongeBuilderRegistry builderRegistry, SpongeFactoryRegistry factoryRegistry) {
        this.catalogRegistry = catalogRegistry;
        this.builderRegistry = builderRegistry;
        this.factoryRegistry = factoryRegistry;
    }

    @Override
    public SpongeCatalogRegistry getCatalogRegistry() {
        return this.catalogRegistry;
    }

    @Override
    public AdventureRegistry getAdventureRegistry() {
        return AdventureRegistryImpl.INSTANCE;
    }

    @Override
    public SpongeBuilderRegistry getBuilderRegistry() {
        return this.builderRegistry;
    }

    @Override
    public FactoryRegistry getFactoryRegistry() {
        return this.factoryRegistry;
    }

    @Override
    public RecipeRegistry getRecipeRegistry() {
        return (RecipeRegistry)((MinecraftServer)Sponge.getServer()).getRecipeManager();
    }

    @Override
    public VillagerRegistry getVillagerRegistry() {
        return SpongeVillagerRegistry.getInstance();
    }
}

