/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.builtin.sponge;

import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.schematic.SpongePaletteType;

public final class PaletteTypeStreamGenerator {
    private PaletteTypeStreamGenerator() {
    }

    public static Stream<PaletteType> stream() {
        ArrayList<SpongePaletteType<Object>> paletteTypes = new ArrayList<SpongePaletteType<Object>>();
        paletteTypes.add(new SpongePaletteType<BlockState>(ResourceKey.sponge("global_block_palette"), GlobalPalette::getBlockPalette, BlockStateSerializerDeserializer::serialize, BlockStateSerializerDeserializer::deserialize));
        paletteTypes.add(new SpongePaletteType<BlockState>(ResourceKey.sponge("block_state_palette"), () -> new MutableBimapPalette<BlockState>(PaletteTypes.BLOCK_STATE_PALETTE.get()), BlockStateSerializerDeserializer::serialize, BlockStateSerializerDeserializer::deserialize));
        paletteTypes.add(new SpongePaletteType<BiomeType>(ResourceKey.sponge("global_biome_palette"), GlobalPalette::getBiomePalette, type -> {
            ResourceLocation key = Registry.BIOME.getKey((Object)((Biome)(type instanceof VirtualBiomeType ? ((VirtualBiomeType)type).getPersistedType() : type)));
            if (key == null) {
                return "minecraft:plains";
            }
            return key.toString();
        }, id -> Registry.BIOME.getValue(ResourceLocation.tryCreate((String)id))));
        paletteTypes.add(new SpongePaletteType<BiomeType>(ResourceKey.sponge("biome_palette"), () -> new MutableBimapPalette<BiomeType>(PaletteTypes.BIOME_PALETTE.get()), type -> {
            ResourceLocation key = Registry.BIOME.getKey((Object)((Biome)(type instanceof VirtualBiomeType ? ((VirtualBiomeType)type).getPersistedType() : type)));
            if (key == null) {
                return "minecraft:plains";
            }
            return key.toString();
        }, id -> Registry.BIOME.getValue(ResourceLocation.tryCreate((String)id))));
        return paletteTypes.stream();
    }
}

