/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.builtin.sponge;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.dimension.DimensionTypes;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.world.SpongeWorldArchetypeBuilder;
import org.spongepowered.common.world.dimension.SpongeDimensionType;

public final class WorldArchetypeStreamGenerator {
    private WorldArchetypeStreamGenerator() {
    }

    public static Stream<WorldArchetype> stream() {
        return Stream.of(WorldArchetypeStreamGenerator.newArchetype(ResourceKey.sponge("overworld"), DimensionTypes.OVERWORLD), WorldArchetypeStreamGenerator.newArchetype(ResourceKey.sponge("the_nether"), DimensionTypes.THE_NETHER), WorldArchetypeStreamGenerator.newArchetype(ResourceKey.sponge("the_end"), DimensionTypes.THE_END), WorldArchetypeStreamGenerator.newArchetype(ResourceKey.sponge("the_void"), DimensionTypes.THE_END));
    }

    private static WorldArchetype newArchetype(ResourceKey key, Supplier<DimensionType> dimensionType) {
        WorldSettings archetype = new WorldSettings(SpongeWorldArchetypeBuilder.RANDOM.nextLong(), GameType.SURVIVAL, true, false, WorldType.DEFAULT);
        ((ResourceKeyBridge)archetype).bridge$setKey(key);
        ((WorldSettingsBridge)archetype).bridge$setLogicType((SpongeDimensionType)dimensionType.get());
        ((WorldSettingsBridge)archetype).bridge$setDifficulty(Difficulty.NORMAL);
        if (dimensionType.get() == DimensionTypes.OVERWORLD.get()) {
            ((WorldSettingsBridge)archetype).bridge$setGenerateSpawnOnLoad(true);
        }
        return (WorldArchetype)archetype;
    }
}

