/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import co.aikar.timings.Timings;
import org.spongepowered.common.relocate.co.aikar.timings.TimingData;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHandler;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingIdentifier;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsExport;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;

public final class FullServerTickHandler
extends TimingHandler {
    private static final TimingIdentifier IDENTITY = new TimingIdentifier("Minecraft", "Full Server Tick", null, false);
    final TimingData minuteData = new TimingData(this.id);
    double avgFreeMemory = -1.0;
    double avgUsedMemory = -1.0;

    FullServerTickHandler() {
        super(IDENTITY);
        TimingsManager.TIMING_MAP.put(IDENTITY, this);
    }

    @Override
    public TimingHandler startTiming() {
        if (TimingsManager.needsFullReset) {
            TimingsManager.resetTimings();
        } else if (TimingsManager.needsRecheckEnabled) {
            TimingsManager.recheckEnabled();
        }
        super.startTiming();
        return this;
    }

    @Override
    public void stopTiming() {
        super.stopTiming();
        if (!this.enabled) {
            return;
        }
        if (TimingHistory.timedTicks % 20L == 0L) {
            Runtime runtime = Runtime.getRuntime();
            double usedMemory = runtime.totalMemory() - runtime.freeMemory();
            double freeMemory = (double)runtime.maxMemory() - usedMemory;
            this.avgFreeMemory = this.avgFreeMemory == -1.0 ? freeMemory : this.avgFreeMemory * 0.9833333333333333 + freeMemory * 0.016666666666666666;
            this.avgUsedMemory = this.avgUsedMemory == -1.0 ? usedMemory : this.avgUsedMemory * 0.9833333333333333 + usedMemory * 0.016666666666666666;
        }
        long start = System.nanoTime();
        TimingsManager.tick();
        long diff = System.nanoTime() - start;
        TimingsManager.CURRENT = TimingsManager.TIMINGS_TICK;
        TimingsManager.TIMINGS_TICK.addDiff(diff);
        --this.record.curTickCount;
        this.minuteData.curTickTotal = this.record.curTickTotal;
        this.minuteData.curTickCount = 1;
        boolean violated = this.isViolated();
        this.minuteData.processTick(violated);
        TimingsManager.TIMINGS_TICK.processTick(violated);
        this.processTick(violated);
        if (TimingHistory.timedTicks % 1200L == 0L) {
            TimingsManager.MINUTE_REPORTS.add(new TimingHistory.MinuteReport());
            TimingHistory.resetTicks(false);
            this.minuteData.reset();
        }
        if (TimingHistory.timedTicks % (long)Timings.getHistoryInterval() == 0L) {
            TimingsManager.HISTORY.add((Object)new TimingHistory());
            TimingsManager.resetTimings();
        }
        TimingsExport.reportTimings();
    }

    boolean isViolated() {
        return this.record.curTickTotal > 50000000L;
    }
}

