/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.google.common.collect.EvictingQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.relocate.co.aikar.timings.FullServerTickHandler;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHandler;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingIdentifier;
import org.spongepowered.common.relocate.co.aikar.timings.UnsafeTimingHandler;
import org.spongepowered.common.relocate.co.aikar.util.LoadingMap;
import org.spongepowered.plugin.PluginContainer;

public final class TimingsManager {
    static final Map<TimingIdentifier, TimingHandler> TIMING_MAP = Collections.synchronizedMap(LoadingMap.newHashMap(id -> id.protect ? new UnsafeTimingHandler((TimingIdentifier)id) : new TimingHandler((TimingIdentifier)id), 256, 0.5f));
    public static final FullServerTickHandler FULL_SERVER_TICK = new FullServerTickHandler();
    public static final TimingHandler TIMINGS_TICK = SpongeTimingsFactory.ofSafe("Timings Tick", FULL_SERVER_TICK);
    public static final Timing DATA_GROUP_HANDLER = SpongeTimingsFactory.ofSafe("Data");
    public static final Timing MOD_EVENT_HANDLER = SpongeTimingsFactory.ofSafe("Mod Events");
    public static final Timing PLUGIN_SCHEDULER_HANDLER = SpongeTimingsFactory.ofSafe("Plugin Scheduler");
    public static final Timing PLUGIN_EVENT_HANDLER = SpongeTimingsFactory.ofSafe("Plugin Events");
    public static final Timing PLUGIN_GROUP_HANDLER = SpongeTimingsFactory.ofSafe("Plugins");
    public static List<String> hiddenConfigs = new ArrayList<String>();
    public static boolean privacy = false;
    static final Collection<TimingHandler> HANDLERS = new ArrayDeque<TimingHandler>();
    static final ArrayDeque<TimingHistory.MinuteReport> MINUTE_REPORTS = new ArrayDeque();
    static EvictingQueue<TimingHistory> HISTORY = EvictingQueue.create((int)12);
    static TimingHandler CURRENT;
    static long timingStart;
    static long historyStart;
    static boolean needsFullReset;
    static boolean needsRecheckEnabled;

    private TimingsManager() {
    }

    static void reset() {
        needsFullReset = true;
    }

    static void tick() {
        if (Timings.isTimingsEnabled()) {
            boolean violated = FULL_SERVER_TICK.isViolated();
            for (TimingHandler handler : HANDLERS) {
                if (handler.isSpecial()) continue;
                handler.processTick(violated);
            }
            TimingHistory.playerTicks += (long)SpongeCommon.getGame().getServer().getOnlinePlayers().size();
            ++TimingHistory.timedTicks;
        }
    }

    static void stopServer() {
        Timings.setTimingsEnabled(false);
        TimingsManager.recheckEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void recheckEnabled() {
        Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
        synchronized (map) {
            for (TimingHandler timings : TIMING_MAP.values()) {
                timings.checkEnabled();
            }
        }
        needsRecheckEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetTimings() {
        if (needsFullReset) {
            Map<TimingIdentifier, TimingHandler> map = TIMING_MAP;
            synchronized (map) {
                for (TimingHandler timings : TIMING_MAP.values()) {
                    timings.reset(true);
                }
            }
            if (timingStart != 0L) {
                SpongeCommon.getLogger().info("Timings reset");
            }
            HISTORY.clear();
            needsFullReset = false;
            needsRecheckEnabled = false;
            timingStart = System.currentTimeMillis();
        } else {
            for (TimingHandler timings : HANDLERS) {
                timings.reset(false);
            }
        }
        HANDLERS.clear();
        MINUTE_REPORTS.clear();
        TimingHistory.resetTicks(true);
        historyStart = System.currentTimeMillis();
    }

    static TimingHandler getHandler(String group, String name, Timing parent, boolean protect) {
        return TIMING_MAP.get(new TimingIdentifier(group, name, parent, protect));
    }

    public static Timing getCommandTiming(String pluginName, CommandMapping command) {
        Optional<Object> plugin = Optional.empty();
        if (!("minecraft".equals(pluginName) || "bukkit".equals(pluginName) || "Spigot".equals(pluginName))) {
            plugin = SpongeCommon.getGame().getPluginManager().getPlugin(pluginName);
        }
        if (!plugin.isPresent()) {
            return SpongeTimingsFactory.ofSafe("Command: " + pluginName + ":" + command.getPrimaryAlias());
        }
        return SpongeTimingsFactory.ofSafe((PluginContainer)plugin.get(), "Command: " + pluginName + ":" + command.getPrimaryAlias());
    }

    static {
        timingStart = 0L;
        historyStart = 0L;
        needsFullReset = false;
        needsRecheckEnabled = false;
    }
}

