/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;

public final class JSONUtil {
    static final Gson gson = new GsonBuilder().serializeNulls().create();

    private JSONUtil() {
    }

    public static JsonArray arrayOf(Object ... elements) {
        return gson.toJsonTree(elements).getAsJsonArray();
    }

    public static JsonObjectBuilder objectBuilder() {
        return new JsonObjectBuilder();
    }

    public static JsonObject singleObjectPair(String key, Object value) {
        return JSONUtil.objectBuilder().add(key, value).build();
    }

    public static JsonObject singleObjectPair(int key, Object value) {
        return JSONUtil.objectBuilder().add(key, value).build();
    }

    public static <E> JsonArray mapArray(E[] elements, Function<E, Object> function) {
        return JSONUtil.mapArray(Lists.newArrayList((Object[])elements), function);
    }

    public static <E> JsonArray mapArray(Iterable<E> elements, Function<E, Object> function) {
        ArrayList list = Lists.newArrayList();
        for (E element : elements) {
            Object transformed = function.apply(element);
            if (transformed == null) continue;
            list.add(transformed);
        }
        return gson.toJsonTree(list).getAsJsonArray();
    }

    public static <E> JsonObject mapArrayToObject(E[] array, Function<E, JsonObject> function) {
        return JSONUtil.mapArrayToObject(Lists.newArrayList((Object[])array), function);
    }

    public static <E> JsonObject mapArrayToObject(Iterable<E> iterable, Function<E, JsonObject> function) {
        JsonObjectBuilder builder = JSONUtil.objectBuilder();
        for (E element : iterable) {
            JsonObject obj = function.apply(element);
            if (obj == null) continue;
            for (Map.Entry<String, JsonElement> entry : obj.entrySet()) {
                builder.add(entry.getKey(), (Object)entry.getValue());
            }
        }
        return builder.build();
    }

    public static String toString(JsonElement element) {
        return gson.toJson(element);
    }

    public static JsonElement toJsonElement(Object value) {
        return gson.toJsonTree(value);
    }

    public static class JsonObjectBuilder {
        private final Map<String, Object> elements = Maps.newHashMap();

        public JsonObjectBuilder add(int key, Object value) {
            return this.add(String.valueOf(key), value);
        }

        public JsonObjectBuilder add(String key, Object value) {
            if (value instanceof JsonObjectBuilder) {
                value = ((JsonObjectBuilder)value).build();
            }
            this.elements.put(key, value);
            return this;
        }

        public JsonObject build() {
            return gson.toJsonTree(this.elements).getAsJsonObject();
        }
    }
}

