/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.resourcepack;

import com.google.common.base.MoreObjects;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.resourcepack.ResourcePack;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.resourcepack.SpongeURIResourcePack;
import org.spongepowered.common.resourcepack.SpongeWorldResourcePack;

public abstract class SpongeResourcePack
implements ResourcePack {
    private final String hash;
    private final String id = UUID.randomUUID().toString();
    public static final int HASH_SIZE = 40;

    public SpongeResourcePack(@Nullable String hash) {
        this.hash = hash;
    }

    public abstract String getUrlString();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<String> getHash() {
        return Optional.of(this.hash);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("uri", (Object)this.getUri()).toString();
    }

    public static SpongeResourcePack create(String uri, String hash) throws URISyntaxException {
        if (uri.startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash);
        }
        if (hash != null && hash.length() != 40) {
            hash = null;
        }
        return new SpongeURIResourcePack(uri, hash);
    }

    public static SpongeResourcePack create(URI uri, String hash) {
        if (uri.toString().startsWith("level://")) {
            return new SpongeWorldResourcePack(uri, hash);
        }
        return new SpongeURIResourcePack(uri, hash);
    }

    public static final class Factory
    implements ResourcePack.Factory {
        @Override
        public ResourcePack fromUri(URI uri) throws FileNotFoundException {
            Objects.requireNonNull(uri);
            try {
                Hasher hasher = Hashing.sha1().newHasher();
                try (InputStream in = Factory.openStream(uri);){
                    int read;
                    byte[] buf = new byte[256];
                    while ((read = in.read(buf)) > 0) {
                        hasher.putBytes(buf, 0, read);
                    }
                }
                return SpongeResourcePack.create(uri, hasher.hash().toString());
            }
            catch (IOException e) {
                FileNotFoundException ex = new FileNotFoundException(e.toString());
                ex.initCause(e);
                throw ex;
            }
        }

        private static InputStream openStream(URI uri) throws IOException {
            if (uri.toString().startsWith("level://")) {
                return Files.newInputStream(SpongeCommon.getGameDirectory().resolve(uri.toString().substring("level://".length())), new OpenOption[0]);
            }
            return uri.toURL().openStream();
        }

        @Override
        public ResourcePack fromUriUnchecked(URI uri) {
            return SpongeResourcePack.create(Objects.requireNonNull(uri), null);
        }
    }
}

