/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import co.aikar.timings.Timing;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.common.scheduler.SpongeScheduledTask;
import org.spongepowered.common.scheduler.SpongeTask;
import org.spongepowered.common.scheduler.SpongeTaskBuilder;
import org.spongepowered.common.scheduler.SpongeTaskExecutorService;
import org.spongepowered.plugin.PluginContainer;

public abstract class SpongeScheduler
implements Scheduler {
    private static final int TICK_DURATION_MS = 50;
    static final long TICK_DURATION_NS = TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS);
    private final String tag;
    private final Map<UUID, SpongeScheduledTask> taskMap = new ConcurrentHashMap<UUID, SpongeScheduledTask>();
    private long sequenceNumber = 0L;

    SpongeScheduler(String tag) {
        this.tag = tag;
    }

    protected long getTimestamp(SpongeScheduledTask task) {
        return System.nanoTime();
    }

    protected void addTask(SpongeScheduledTask task) {
        task.setTimestamp(this.getTimestamp(task));
        this.taskMap.put(task.getUniqueId(), task);
    }

    private void removeTask(SpongeScheduledTask task) {
        this.taskMap.remove(task.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ScheduledTask> getTaskById(UUID id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        Map<UUID, SpongeScheduledTask> map = this.taskMap;
        synchronized (map) {
            return Optional.ofNullable(this.taskMap.get(id));
        }
    }

    @Override
    public Set<ScheduledTask> getTasksByName(String pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
        Pattern searchPattern = Pattern.compile(pattern);
        Set<ScheduledTask> matchingTasks = this.getTasks();
        Iterator<ScheduledTask> it = matchingTasks.iterator();
        while (it.hasNext()) {
            Matcher matcher = searchPattern.matcher(it.next().getName());
            if (matcher.matches()) continue;
            it.remove();
        }
        return matchingTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ScheduledTask> getTasks() {
        Map<UUID, SpongeScheduledTask> map = this.taskMap;
        synchronized (map) {
            return Sets.newHashSet(this.taskMap.values());
        }
    }

    @Override
    public Set<ScheduledTask> getTasksByPlugin(PluginContainer plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        String testOwnerId = plugin.getMetadata().getId();
        Set<ScheduledTask> allTasks = this.getTasks();
        Iterator<ScheduledTask> it = allTasks.iterator();
        while (it.hasNext()) {
            String taskOwnerId = it.next().getOwner().getMetadata().getId();
            if (testOwnerId.equals(taskOwnerId)) continue;
            it.remove();
        }
        return allTasks;
    }

    @Override
    public SpongeTaskExecutorService createExecutor(PluginContainer plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        return new SpongeTaskExecutorService(() -> Task.builder().plugin(plugin), this);
    }

    @Override
    public SpongeScheduledTask submit(Task task) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        SpongeScheduledTask scheduledTask = new SpongeScheduledTask(this, (SpongeTask)task, task.getName() + "-" + this.tag + "-#" + this.sequenceNumber++);
        this.addTask(scheduledTask);
        return scheduledTask;
    }

    final void runTick() {
        this.preTick();
        TimingsManager.PLUGIN_SCHEDULER_HANDLER.startTimingIfSync();
        try {
            this.taskMap.values().forEach(this::processTask);
            this.postTick();
        }
        finally {
            this.finallyPostTick();
        }
        TimingsManager.PLUGIN_SCHEDULER_HANDLER.stopTimingIfSync();
    }

    protected void preTick() {
    }

    protected void postTick() {
    }

    protected void finallyPostTick() {
    }

    private void processTask(SpongeScheduledTask task) {
        if (task.getState() == SpongeScheduledTask.ScheduledTaskState.CANCELED) {
            this.removeTask(task);
            return;
        }
        if (task.getState() == SpongeScheduledTask.ScheduledTaskState.EXECUTING) {
            return;
        }
        long threshold = Long.MAX_VALUE;
        if (task.getState() == SpongeScheduledTask.ScheduledTaskState.WAITING) {
            threshold = task.task.delay;
        } else if (task.getState() == SpongeScheduledTask.ScheduledTaskState.RUNNING) {
            threshold = task.task.interval;
        }
        long now = this.getTimestamp(task);
        if (threshold <= now - task.getTimestamp()) {
            task.setState(SpongeScheduledTask.ScheduledTaskState.SWITCHING);
            task.setTimestamp(this.getTimestamp(task));
            this.startTask(task);
            if (task.task.interval == 0L) {
                this.removeTask(task);
            }
        }
    }

    private void startTask(SpongeScheduledTask task) {
        this.executeTaskRunnable(task, () -> {
            task.setState(SpongeScheduledTask.ScheduledTaskState.EXECUTING);
            try (PhaseContext<?> context = this.createContext(task, task.getOwner());
                 Timing timings = task.task.getTimingsHandler();){
                timings.startTimingIfSync();
                if (context != null) {
                    context.buildAndSwitch();
                }
                try {
                    SpongeCommon.setActivePlugin(task.getOwner());
                    task.task.getConsumer().accept(task);
                }
                catch (Throwable t) {
                    SpongeCommon.getLogger().error("The Scheduler tried to run the task '{}' owned by '{}' but an error occurred.", (Object)task.getName(), (Object)task.getOwner().getMetadata().getId(), (Object)t);
                }
            }
            finally {
                if (!task.isCancelled()) {
                    task.setState(SpongeScheduledTask.ScheduledTaskState.RUNNING);
                }
                SpongeCommon.setActivePlugin(null);
                this.onTaskCompletion(task);
            }
        });
    }

    @Nullable
    protected PhaseContext<?> createContext(SpongeScheduledTask task, PluginContainer container) {
        return null;
    }

    protected void onTaskCompletion(SpongeScheduledTask task) {
    }

    protected abstract void executeTaskRunnable(SpongeScheduledTask var1, Runnable var2);

    public <V> Future<V> execute(Callable<V> callable) {
        FutureTask<V> runnable = new FutureTask<V>(callable);
        this.submit(new SpongeTaskBuilder().execute(runnable).plugin(SpongeCommon.getPlugin()).build());
        return runnable;
    }

    public Future<?> execute(Runnable runnable) {
        return this.execute(() -> {
            runnable.run();
            return null;
        });
    }
}

