/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeTask
implements Task {
    final long delay;
    final long interval;
    final boolean tickBased;
    @Nullable
    final String customName;
    private final PluginContainer owner;
    private final Consumer<ScheduledTask> consumer;
    private final String name;
    @Nullable
    private Timing taskTimer;

    SpongeTask(Consumer<ScheduledTask> task, String name, String customName, PluginContainer pluginContainer, long delay, long interval, boolean tickBased) {
        this.delay = delay;
        this.interval = interval;
        this.owner = pluginContainer;
        this.consumer = task;
        this.name = name;
        this.customName = customName;
        this.tickBased = tickBased;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PluginContainer getOwner() {
        return this.owner;
    }

    @Override
    public Duration getDelay() {
        return Duration.ofNanos(this.delay);
    }

    @Override
    public Duration getInterval() {
        return Duration.ofNanos(this.interval);
    }

    @Override
    public Consumer<ScheduledTask> getConsumer() {
        return this.consumer;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("delay", this.delay).add("interval", this.interval).add("owner", (Object)this.owner.getMetadata().getId()).toString();
    }

    Timing getTimingsHandler() {
        if (this.taskTimer == null) {
            this.taskTimer = SpongeTimings.getPluginSchedulerTimings(this.owner);
        }
        return this.taskTimer;
    }

    public static final class Builder
    implements Task.Builder {
        private static final AtomicInteger taskCounter = new AtomicInteger();
        @Nullable
        private Consumer<ScheduledTask> consumer;
        @Nullable
        private PluginContainer plugin;
        @Nullable
        private String name;
        private long delay;
        private long interval;
        private boolean tickBasedDelay;
        private boolean tickBasedInterval;

        @Override
        public Task.Builder execute(Consumer<ScheduledTask> executor) {
            this.consumer = Objects.requireNonNull(executor);
            return this;
        }

        @Override
        public Task.Builder delay(long delay, TemporalUnit unit) {
            Objects.requireNonNull(unit);
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder delay(long delay, TimeUnit unit) {
            Objects.requireNonNull(unit);
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = Objects.requireNonNull(unit, "unit").toNanos(delay);
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder delay(Ticks delay) {
            Objects.requireNonNull(delay);
            if (delay.getTicks() < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.delay = delay.getTicks() * SpongeScheduler.TICK_DURATION_NS;
            this.tickBasedDelay = true;
            return this;
        }

        @Override
        public Task.Builder delay(Duration delay) {
            this.delay = Objects.requireNonNull(delay).toNanos();
            this.tickBasedDelay = false;
            return this;
        }

        @Override
        public Task.Builder interval(Duration interval) {
            this.interval = Objects.requireNonNull(interval).toNanos();
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(long delay, TemporalUnit unit) {
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be equal to or greater than zero!");
            }
            this.interval = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(long interval, TimeUnit unit) {
            if (interval < 0L) {
                throw new IllegalArgumentException("Interval must be equal to or greater than zero!");
            }
            this.interval = Objects.requireNonNull(unit).toNanos(interval);
            this.tickBasedInterval = false;
            return this;
        }

        @Override
        public Task.Builder interval(Ticks interval) {
            Objects.requireNonNull(interval);
            if (interval.getTicks() < 0L) {
                throw new IllegalArgumentException("Interval must be equal to or greater than zero!");
            }
            this.interval = interval.getTicks() * SpongeScheduler.TICK_DURATION_NS;
            this.tickBasedInterval = true;
            return this;
        }

        @Override
        public Task.Builder name(String name) {
            if (name != null && name.isEmpty()) {
                throw new IllegalArgumentException("Name cannot be empty!");
            }
            this.name = name;
            return this;
        }

        @Override
        public Task.Builder plugin(PluginContainer plugin) {
            this.plugin = Objects.requireNonNull(plugin);
            return this;
        }

        @Override
        public Task.Builder from(Task value) {
            Objects.requireNonNull(value);
            SpongeTask task = (SpongeTask)value;
            this.consumer = value.getConsumer();
            this.plugin = task.getOwner();
            this.interval = task.interval;
            this.delay = task.delay;
            this.tickBasedDelay = task.tickBased;
            this.tickBasedInterval = task.tickBased;
            this.name = task.customName;
            return this;
        }

        @Override
        public Task.Builder reset() {
            this.consumer = null;
            this.plugin = null;
            this.interval = 0L;
            this.delay = 0L;
            this.tickBasedDelay = false;
            this.tickBasedInterval = false;
            this.name = null;
            return this;
        }

        @Override
        public Task build() {
            Objects.requireNonNull(this.consumer);
            Objects.requireNonNull(this.plugin);
            String name = this.name == null ? this.plugin.getMetadata().getId() + "-" + taskCounter.incrementAndGet() : this.name;
            return new SpongeTask(this.consumer, name, this.name, this.plugin, this.delay, this.interval, this.tickBasedDelay && this.tickBasedInterval);
        }
    }
}

