/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.scheduler.SpongeTask;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeTaskBuilder
implements Task.Builder {
    private static final AtomicInteger taskCounter = new AtomicInteger();
    private @Nullable Consumer<ScheduledTask> consumer;
    private @Nullable PluginContainer plugin;
    private @Nullable String name;
    private long delay;
    private long interval;
    private boolean tickBasedDelay;
    private boolean tickBasedInterval;

    @Override
    public Task.Builder execute(Consumer<ScheduledTask> executor) {
        this.consumer = Objects.requireNonNull(executor, "executor");
        return this;
    }

    @Override
    public Task.Builder delay(long delay, TemporalUnit unit) {
        Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0, (Object)"Delay cannot be negative");
        this.delay = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
        this.tickBasedDelay = false;
        return this;
    }

    @Override
    public Task.Builder delay(long delay, TimeUnit unit) {
        Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0, (Object)"Delay cannot be negative");
        this.delay = Objects.requireNonNull(unit, "unit").toNanos(delay);
        this.tickBasedDelay = false;
        return this;
    }

    @Override
    public Task.Builder delay(Ticks delay) {
        Preconditions.checkArgument((delay.getTicks() >= 0L ? 1 : 0) != 0, (Object)"Delay cannot be negative");
        this.delay = delay.getTicks() * SpongeScheduler.TICK_DURATION_NS;
        this.tickBasedDelay = true;
        return this;
    }

    @Override
    public Task.Builder delay(Duration delay) {
        this.delay = Objects.requireNonNull(delay, "delay").toNanos();
        this.tickBasedDelay = false;
        return this;
    }

    @Override
    public Task.Builder interval(Duration interval) {
        this.interval = Objects.requireNonNull(interval, "interval").toNanos();
        this.tickBasedInterval = false;
        return this;
    }

    @Override
    public Task.Builder interval(long delay, TemporalUnit unit) {
        Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0, (Object)"Interval cannot be negative");
        this.interval = Objects.requireNonNull(unit, "unit").getDuration().toNanos() * delay;
        this.tickBasedInterval = false;
        return this;
    }

    @Override
    public Task.Builder interval(long interval, TimeUnit unit) {
        Preconditions.checkArgument((interval >= 0L ? 1 : 0) != 0, (Object)"Interval cannot be negative");
        this.interval = Objects.requireNonNull(unit, "unit").toNanos(interval);
        this.tickBasedInterval = false;
        return this;
    }

    @Override
    public Task.Builder interval(Ticks interval) {
        Preconditions.checkArgument((interval.getTicks() >= 0L ? 1 : 0) != 0, (Object)"Interval cannot be negative");
        this.interval = interval.getTicks() * SpongeScheduler.TICK_DURATION_NS;
        this.tickBasedInterval = true;
        return this;
    }

    @Override
    public Task.Builder name(String name) {
        Preconditions.checkArgument((!Objects.requireNonNull(name, "name").isEmpty() ? 1 : 0) != 0, (Object)"Name cannot be empty");
        this.name = name;
        return this;
    }

    @Override
    public Task.Builder plugin(PluginContainer plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        return this;
    }

    @Override
    public Task build() {
        Preconditions.checkState((this.consumer != null ? 1 : 0) != 0, (Object)"Runnable task not set");
        Preconditions.checkState((this.plugin != null ? 1 : 0) != 0, (Object)"Plugin not set");
        String name = this.name == null ? this.plugin.getMetadata().getId() + "-" + taskCounter.incrementAndGet() : this.name;
        return new SpongeTask(this.consumer, name, this.name, this.plugin, this.delay, this.interval, this.tickBasedDelay && this.tickBasedInterval);
    }

    @Override
    public Task.Builder from(Task value) {
        SpongeTask task = (SpongeTask)value;
        this.consumer = value.getConsumer();
        this.plugin = task.getOwner();
        this.interval = task.interval;
        this.delay = task.delay;
        this.tickBasedDelay = task.tickBased;
        this.tickBasedInterval = task.tickBased;
        this.name = task.customName;
        return this;
    }

    @Override
    public Task.Builder reset() {
        this.consumer = null;
        this.plugin = null;
        this.interval = 0L;
        this.delay = 0L;
        this.tickBasedDelay = false;
        this.tickBasedInterval = false;
        this.name = null;
        return this;
    }
}

