/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scheduler;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.spongepowered.api.scheduler.ScheduledTask;
import org.spongepowered.api.scheduler.ScheduledTaskFuture;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scheduler.TaskExecutorService;
import org.spongepowered.api.scheduler.TaskFuture;
import org.spongepowered.common.scheduler.SpongeScheduledTask;
import org.spongepowered.common.scheduler.SpongeScheduler;

class SpongeTaskExecutorService
extends AbstractExecutorService
implements TaskExecutorService {
    private final Supplier<Task.Builder> taskBuilderProvider;
    private final SpongeScheduler scheduler;

    SpongeTaskExecutorService(Supplier<Task.Builder> taskBuilderProvider, SpongeScheduler scheduler) {
        this.taskBuilderProvider = taskBuilderProvider;
        this.scheduler = scheduler;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return ImmutableList.of();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    @Override
    public void execute(Runnable command) {
        this.submitTask(this.createTask(command).build());
    }

    @Override
    public TaskFuture<?> submit(Runnable command) {
        return this.submit(command, (Object)null);
    }

    @Override
    public <T> TaskFuture<T> submit(Runnable command, @Nullable T result) {
        FutureTask<T> runnable = new FutureTask<T>(command, result);
        Task task = this.createTask(runnable).build();
        return new LanternScheduledFuture<T>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public <T> TaskFuture<T> submit(Callable<T> command) {
        FutureTask<T> runnable = new FutureTask<T>(command);
        Task task = this.createTask(runnable).build();
        return new LanternScheduledFuture<T>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public ScheduledTaskFuture<?> schedule(Runnable command, long delay, TemporalUnit unit) {
        FutureTask<Object> runnable = new FutureTask<Object>(command, null);
        Task task = this.createTask(runnable).delay(delay, unit).build();
        return new LanternScheduledFuture<Object>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public ScheduledTaskFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        FutureTask<Object> runnable = new FutureTask<Object>(command, null);
        Task task = this.createTask(runnable).delay(delay, unit).build();
        return new LanternScheduledFuture<Object>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public <V> ScheduledTaskFuture<V> schedule(Callable<V> callable, long delay, TemporalUnit unit) {
        FutureTask<V> runnable = new FutureTask<V>(callable);
        Task task = this.createTask(runnable).delay(delay, unit).build();
        return new LanternScheduledFuture<V>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public <V> ScheduledTaskFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        FutureTask<V> runnable = new FutureTask<V>(callable);
        Task task = this.createTask(runnable).delay(delay, unit).build();
        return new LanternScheduledFuture<V>(runnable, this.submitTask(task), this.scheduler);
    }

    @Override
    public ScheduledTaskFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TemporalUnit unit) {
        RepeatableFutureTask runnable = new RepeatableFutureTask(command);
        Task task = this.createTask(runnable).delay(initialDelay, unit).interval(period, unit).build();
        SpongeScheduledTask scheduledTask = this.submitTask(task);
        runnable.setTask(scheduledTask);
        return new LanternScheduledFuture(runnable, scheduledTask, this.scheduler);
    }

    @Override
    public ScheduledTaskFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        RepeatableFutureTask runnable = new RepeatableFutureTask(command);
        Task task = this.createTask(runnable).delay(initialDelay, unit).interval(period, unit).build();
        SpongeScheduledTask scheduledTask = this.submitTask(task);
        runnable.setTask(scheduledTask);
        return new LanternScheduledFuture(runnable, scheduledTask, this.scheduler);
    }

    @Override
    public ScheduledTaskFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TemporalUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    @Override
    public ScheduledTaskFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    private Task.Builder createTask(Runnable command) {
        return this.taskBuilderProvider.get().execute(command);
    }

    private SpongeScheduledTask submitTask(Task task) {
        return this.scheduler.submit(task);
    }

    private static class RepeatableFutureTask<V>
    extends FutureTask<V> {
        @Nullable
        private ScheduledTask owningTask = null;

        RepeatableFutureTask(Runnable runnable) {
            super(runnable, null);
        }

        void setTask(ScheduledTask task) {
            this.owningTask = task;
            if (this.isDone() && !this.isCancelled()) {
                this.owningTask.cancel();
            }
        }

        @Override
        protected void done() {
            if (!this.isCancelled() && this.owningTask != null) {
                this.owningTask.cancel();
            }
        }

        @Override
        public void run() {
            super.runAndReset();
        }
    }

    private static class LanternScheduledFuture<V>
    implements ScheduledTaskFuture<V> {
        private final FutureTask<V> runnable;
        private final SpongeScheduledTask task;
        private final SpongeScheduler scheduler;

        LanternScheduledFuture(FutureTask<V> runnable, SpongeScheduledTask task, SpongeScheduler scheduler) {
            this.runnable = runnable;
            this.task = task;
            this.scheduler = scheduler;
        }

        @Override
        public ScheduledTask getTask() {
            return this.task;
        }

        @Override
        public boolean isPeriodic() {
            Duration interval = this.task.task.getInterval();
            return interval.toMillis() > 0L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.task.nextExecutionTimestamp() - this.scheduler.getTimestamp(this.task), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof LanternScheduledFuture) {
                SpongeScheduledTask otherTask = ((LanternScheduledFuture)other).task;
                return ComparisonChain.start().compare(this.task.nextExecutionTimestamp(), otherTask.nextExecutionTimestamp()).compare((Comparable)this.task.getUniqueId(), (Comparable)otherTask.getUniqueId()).result();
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), other.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public void run() {
            this.runnable.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.task.cancel();
            return this.runnable.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.runnable.isCancelled() || this.task.getState() == SpongeScheduledTask.ScheduledTaskState.CANCELED && !this.runnable.isDone();
        }

        @Override
        public boolean isDone() {
            return this.runnable.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.runnable.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.runnable.get(timeout, unit);
        }
    }
}

