/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.util.text.TextFormatting;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.adventure.SpongeAdventure;

public final class SpongeDisplaySlot
extends SpongeCatalogType
implements DisplaySlot {
    private final int index;
    private final @Nullable TextFormatting formatting;
    private final @Nullable Function<TextFormatting, DisplaySlot> withColorFunction;
    private @Nullable NamedTextColor color;

    public SpongeDisplaySlot(ResourceKey key, int index) {
        this(key, index, null, null);
    }

    public SpongeDisplaySlot(ResourceKey key, int index, @Nullable TextFormatting color, @Nullable Function<TextFormatting, DisplaySlot> withColorFunction) {
        super(key);
        this.withColorFunction = withColorFunction;
        this.index = index;
        this.formatting = color;
    }

    @Override
    public DisplaySlot withTeamColor(@Nullable NamedTextColor color) {
        if (this.withColorFunction == null) {
            return this;
        }
        DisplaySlot slot = this.withColorFunction.apply(color == null ? TextFormatting.RESET : SpongeAdventure.asVanilla(color));
        return slot == null ? this : slot;
    }

    @Override
    public Optional<NamedTextColor> getTeamColor() {
        if (this.color == null) {
            this.color = SpongeAdventure.asAdventureNamed(this.formatting);
        }
        return Optional.ofNullable(this.color);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("color", (Object)this.color);
    }
}

