/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.scoreboard.ScoreObjective;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.common.accessor.scoreboard.ScoreAccessor;
import org.spongepowered.common.accessor.scoreboard.ScoreObjectiveAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.scoreboard.ScoreBridge;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;

public final class SpongeScore
implements Score {
    private final Component name;
    public String legacyName;
    private int score;
    private boolean locked;
    private final Map<ScoreObjective, net.minecraft.scoreboard.Score> scores = new HashMap<ScoreObjective, net.minecraft.scoreboard.Score>();

    public SpongeScore(Component name) {
        this.name = name;
        this.legacyName = SpongeAdventure.legacySection(name);
        if (this.legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("The score name %s is too long! It must be at most %s characters.", this.legacyName, 40));
        }
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
        this.updateScore();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    private void updateScore() {
        for (net.minecraft.scoreboard.Score score : this.scores.values()) {
            int j = ((ScoreAccessor)score).accessor$getScorePoints();
            ((ScoreAccessor)score).accessor$setScorePoints(this.score);
            if (j == this.score && !((ScoreAccessor)score).accessor$getForceUpdate()) continue;
            ((ScoreAccessor)score).accessor$setForceUpdate(false);
            score.getScoreScoreboard().onScoreChanged(score);
        }
    }

    @Override
    public Set<Objective> getObjectives() {
        HashSet<Objective> objectives = new HashSet<Objective>();
        for (ScoreObjective objective : this.scores.keySet()) {
            objectives.add(((ScoreObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return objectives;
    }

    public net.minecraft.scoreboard.Score getScoreFor(ScoreObjective objective) {
        if (this.scores.containsKey(objective)) {
            return this.scores.get(objective);
        }
        net.minecraft.scoreboard.Score score = new net.minecraft.scoreboard.Score(((ScoreObjectiveAccessor)objective).accessor$getScoreboard(), objective, this.legacyName);
        ((ScoreAccessor)score).accessor$setScorePoints(this.score);
        ((ScoreBridge)score).bridge$setSpongeScore(this);
        this.scores.put(objective, score);
        return score;
    }

    public void removeScoreFor(ScoreObjective objective) {
        if (this.scores.remove(objective) == null) {
            throw new IllegalStateException("Attempting to remove an score without an entry!");
        }
    }
}

