/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.leangen.geantyref.TypeToken;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.common.applaunch.config.common.ServicesCategory;
import org.spongepowered.common.event.lifecycle.ProvideServiceEventImpl;
import org.spongepowered.common.service.SpongeServiceProvider;
import org.spongepowered.common.service.game.pagination.SpongePaginationService;
import org.spongepowered.plugin.PluginContainer;

@Singleton
public final class SpongeGameScopedServiceProvider
extends SpongeServiceProvider
implements ServiceProvider.GameScoped {
    @Inject
    public SpongeGameScopedServiceProvider(Game game, Injector injector) {
        super(game, injector);
    }

    @Override
    protected List<SpongeServiceProvider.Service<?>> servicesToSelect() {
        return Collections.singletonList(new SpongeServiceProvider.Service<SpongePaginationService>(PaginationService.class, ServicesCategory.ServicePluginSubCategory::getPaginationService, SpongePaginationService.class));
    }

    @Override
    protected final <T> ProvideServiceEventImpl<T> createEvent(PluginContainer container, SpongeServiceProvider.Service<T> service) {
        return new ProvideServiceEventImpl<T>(Cause.of(EventContext.empty(), this.getGame()), this.getGame(), TypeToken.get(service.getServiceClass()));
    }

    @Override
    public final @NonNull PaginationService paginationService() {
        return this.provideUnchecked(PaginationService.class);
    }
}

