/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.common.service.game.pagination.PaginationCalculator;

abstract class ActivePagination {
    private static final Component SLASH_TEXT = Component.text((String)"/");
    private static final Component DIVIDER_TEXT = Component.space();
    private static final Component CONTINUATION_TEXT = Component.text((String)"...");
    private final Supplier<Optional<? extends Audience>> src;
    private final UUID id = UUID.randomUUID();
    private final Component nextPageText;
    private final Component prevPageText;
    @Nullable
    private final Component title;
    @Nullable
    private final Component header;
    @Nullable
    private final Component footer;
    private int currentPage;
    private final int maxContentLinesPerPage;
    protected final PaginationCalculator calc;
    private final Component padding;

    public ActivePagination(Supplier<Optional<? extends Audience>> src, PaginationCalculator calc, @Nullable Component title, @Nullable Component header, @Nullable Component footer, Component padding) {
        this.src = src;
        this.calc = calc;
        this.title = title;
        this.header = header;
        this.footer = footer;
        this.padding = padding;
        this.nextPageText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00bb").color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.runCommand((String)("/sponge:pagination " + this.id.toString() + " next")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"/page next")))).insertion("/sponge:page next")).build();
        this.prevPageText = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u00ab").color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.runCommand((String)("/sponge:pagination " + this.id.toString() + " prev")))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"/page prev")))).insertion("/sponge:page prev")).build();
        int maxContentLinesPerPage = calc.getLinesPerPage() - 1;
        if (title != null) {
            maxContentLinesPerPage -= calc.getLines(title);
        }
        if (header != null) {
            maxContentLinesPerPage -= calc.getLines(header);
        }
        if (footer != null) {
            maxContentLinesPerPage -= calc.getLines(footer);
        }
        this.maxContentLinesPerPage = maxContentLinesPerPage;
    }

    public UUID getId() {
        return this.id;
    }

    protected abstract Iterable<Component> getLines(int var1) throws CommandException;

    protected abstract boolean hasPrevious(int var1);

    protected abstract boolean hasNext(int var1);

    protected abstract int getTotalPages();

    public void nextPage() throws CommandException {
        this.specificPage(this.currentPage + 1);
    }

    public void previousPage() throws CommandException {
        this.specificPage(this.currentPage - 1);
    }

    protected int getCurrentPage() {
        return this.currentPage;
    }

    protected int getMaxContentLinesPerPage() {
        return this.maxContentLinesPerPage;
    }

    public void specificPage(int page) throws CommandException {
        Audience src = this.src.get().orElseThrow(() -> new CommandException((Component)Component.text((String)("Source for pagination " + this.getId() + " is no longer active!"))));
        this.currentPage = page;
        ArrayList<Component> toSend = new ArrayList<Component>();
        Component title = this.title;
        if (title != null) {
            toSend.add(title);
        }
        if (this.header != null) {
            toSend.add(this.header);
        }
        for (Component line : this.getLines(page)) {
            toSend.add(line);
        }
        Component footer = this.calculateFooter(page);
        toSend.add(this.calc.center(footer, this.padding));
        if (this.footer != null) {
            toSend.add(this.footer);
        }
        for (Component line : toSend) {
            src.sendMessage(Identity.nil(), line);
        }
    }

    protected Component calculateFooter(int currentPage) {
        boolean hasPrevious = this.hasPrevious(currentPage);
        boolean hasNext = this.hasNext(currentPage);
        TextComponent.Builder ret = Component.text();
        if (hasPrevious) {
            ((TextComponent.Builder)ret.append(this.prevPageText)).append(DIVIDER_TEXT);
        } else {
            ((TextComponent.Builder)ret.append((Component)Component.text((String)"\u00ab"))).append(DIVIDER_TEXT);
        }
        boolean needsDiv = false;
        int totalPages = this.getTotalPages();
        if (totalPages > 1) {
            ret.append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(currentPage)).clickEvent(ClickEvent.runCommand((String)("/sponge:pagination " + this.id + ' ' + currentPage)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("/page " + currentPage))))).insertion("/sponge:page " + currentPage)).build());
            ret.append(SLASH_TEXT);
            ret.append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(String.valueOf(totalPages)).clickEvent(ClickEvent.runCommand((String)("/sponge:pagination " + this.id + ' ' + totalPages)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("/page " + totalPages))))).insertion("/sponge:page " + totalPages)).build());
            needsDiv = true;
        }
        if (needsDiv) {
            ret.append(DIVIDER_TEXT);
        }
        if (hasNext) {
            ret.append(this.nextPageText);
        } else {
            ret.append((Component)Component.text((String)"\u00bb"));
        }
        ret.color(this.padding.color());
        if (this.title != null) {
            ret.style(this.title.style());
        }
        return ret.build();
    }

    protected void padPage(List<Component> currentPage, int currentPageLines, boolean addContinuation) {
        int maxContentLinesPerPage = this.getMaxContentLinesPerPage();
        for (int i = currentPageLines; i < maxContentLinesPerPage; ++i) {
            if (addContinuation && i == maxContentLinesPerPage - 1) {
                currentPage.add(CONTINUATION_TEXT);
                continue;
            }
            currentPage.add(0, (Component)Component.empty());
        }
    }
}

