/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeIPBanList
extends IPBanList {
    public SpongeIPBanList(File bansFile) {
        super(bansFile);
    }

    protected boolean hasEntry(String entry) {
        if (entry.equals("local")) {
            return false;
        }
        try {
            return Sponge.getServer().getServiceProvider().banService().isBanned(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    @Nullable
    public IPBanEntry getEntry(String obj) {
        if (obj.equals("local")) {
            return null;
        }
        try {
            return Sponge.getServer().getServiceProvider().banService().getBanFor(InetAddress.getByName(obj)).orElse(null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public void removeEntry(String entry) {
        if (entry.equals("local")) {
            return;
        }
        try {
            Sponge.getServer().getServiceProvider().banService().pardon(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public String[] getKeys() {
        ArrayList<String> ips = new ArrayList<String>();
        for (Ban.Ip ban : Sponge.getServer().getServiceProvider().banService().getIpBans()) {
            ips.add(this.addressToString(new InetSocketAddress(ban.getAddress(), 0)));
        }
        return ips.toArray(new String[0]);
    }

    public void addEntry(IPBanEntry entry) {
        Sponge.getServer().getServiceProvider().banService().addBan((Ban)entry);
    }

    public boolean isEmpty() {
        return Sponge.getServer().getServiceProvider().banService().getIpBans().isEmpty();
    }

    public String addressToString(SocketAddress address) {
        return NetworkUtil.getHostString(address);
    }
}

