/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.service.server.permission.GlobalMemorySubjectData;

public class FixedParentMemorySubjectData
extends GlobalMemorySubjectData {
    private final SubjectReference forcedParent;

    public FixedParentMemorySubjectData(Subject subject, SubjectReference parent) {
        super(subject);
        this.forcedParent = parent;
    }

    @Override
    public List<SubjectReference> getParents(Set<Context> contexts) {
        return ImmutableList.builder().add((Object)this.forcedParent).addAll(super.getParents(contexts)).build();
    }

    @Override
    public CompletableFuture<Boolean> addParent(Set<Context> contexts, SubjectReference parent) {
        if (Objects.equal((Object)this.forcedParent, (Object)parent) && contexts.isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        return super.addParent(contexts, parent);
    }

    @Override
    public CompletableFuture<Boolean> removeParent(Set<Context> contexts, SubjectReference parent) {
        if (Objects.equal((Object)this.forcedParent, (Object)parent)) {
            return CompletableFuture.completedFuture(false);
        }
        return super.removeParent(contexts, parent);
    }
}

