/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.common.service.server.permission.GlobalMemorySubjectData;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongePermissions;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.SpongeSubjectCollection;

public class OpLevelCollection
extends SpongeSubjectCollection {
    private final Map<String, OpLevelSubject> levels;

    public OpLevelCollection(SpongePermissionService service) {
        super("group", service);
        ImmutableMap.Builder build = ImmutableMap.builder();
        for (int i = 0; i <= 4; ++i) {
            build.put((Object)("op_" + i), (Object)new OpLevelSubject(service, i));
        }
        this.levels = build.build();
    }

    @Override
    public SpongeSubject get(String identifier) {
        SpongeSubject subject = this.levels.get(identifier);
        if (subject == null) {
            throw new IllegalArgumentException(identifier + " is not a valid op level group name (op_{0,4})");
        }
        return subject;
    }

    @Override
    public boolean isRegistered(String identifier) {
        return this.levels.containsKey(identifier);
    }

    @Override
    public Collection<Subject> getLoadedSubjects() {
        return this.levels.values();
    }

    public static class OpLevelSubject
    extends SpongeSubject {
        private final SpongePermissionService service;
        private final int level;
        private final MemorySubjectData data;

        public OpLevelSubject(final SpongePermissionService service, final int level) {
            this.service = service;
            this.level = level;
            this.data = new GlobalMemorySubjectData(this){

                @Override
                public List<SubjectReference> getParents(Set<Context> contexts) {
                    if (!contexts.isEmpty()) {
                        return Collections.emptyList();
                    }
                    if (level == 0) {
                        return super.getParents(contexts);
                    }
                    return ImmutableList.builder().add((Object)service.getGroupForOpLevel(level - 1).asSubjectReference()).addAll(super.getParents(contexts)).build();
                }
            };
            SpongePermissions.populateNonCommandPermissions(this.data, (permLevel, name) -> level == permLevel);
        }

        public int getOpLevel() {
            return this.level;
        }

        @Override
        public String getIdentifier() {
            return "op_" + this.level;
        }

        @Override
        public SubjectCollection getContainingCollection() {
            return this.service.getGroupSubjects();
        }

        @Override
        public PermissionService getService() {
            return this.service;
        }

        @Override
        public MemorySubjectData getSubjectData() {
            return this.data;
        }
    }
}

