/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.sql;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.sql.SqlManager;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeSqlManager
implements SqlManager,
Closeable {
    static final Map<String, Properties> PROTOCOL_SPECIFIC_PROPS;
    static final Map<String, BiFunction<PluginContainer, String, String>> PATH_CANONICALIZERS;
    @Nullable
    private LoadingCache<ConnectionInfo, HikariDataSource> connectionCache;

    public SpongeSqlManager() {
        this.buildConnectionCache();
    }

    public void buildConnectionCache() {
        this.connectionCache = null;
        this.connectionCache = Caffeine.newBuilder().removalListener((key, value, cause) -> {
            if (value != null) {
                value.close();
            }
        }).build(key -> {
            HikariConfig config = new HikariConfig();
            config.setUsername(key.getUser());
            config.setPassword(key.getPassword());
            config.setDriverClassName(key.getDriverClassName());
            config.setMaximumPoolSize(Runtime.getRuntime().availableProcessors() * 2 + 1);
            config.setLeakDetectionThreshold(60000L);
            Properties driverSpecificProperties = PROTOCOL_SPECIFIC_PROPS.get(key.getDriverClassName());
            if (driverSpecificProperties != null) {
                config.setDataSourceProperties(driverSpecificProperties);
            }
            config.setJdbcUrl(key.getAuthlessUrl());
            return new HikariDataSource(config);
        });
    }

    @Override
    public DataSource getDataSource(String jdbcConnection) throws SQLException {
        return this.getDataSource(null, jdbcConnection);
    }

    @Override
    public DataSource getDataSource(PluginContainer plugin, String jdbcConnection) throws SQLException {
        Preconditions.checkNotNull(this.connectionCache);
        String jdbcConnectionString = this.getConnectionUrlFromAlias(jdbcConnection).orElse(jdbcConnection);
        ConnectionInfo info = ConnectionInfo.fromUrl(plugin, jdbcConnectionString);
        try {
            return (DataSource)this.connectionCache.get((Object)info);
        }
        catch (CompletionException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connectionCache != null) {
            this.connectionCache.invalidateAll();
        }
    }

    @Override
    public Optional<String> getConnectionUrlFromAlias(String alias) {
        return Optional.ofNullable(SpongeConfigs.getCommon().get().getSql().getAliases().get(alias));
    }

    static {
        ImmutableMap.Builder build = ImmutableMap.builder();
        Properties mySqlProps = new Properties();
        mySqlProps.setProperty("useConfigs", "maxPerformance");
        build.put((Object)"com.mysql.jdbc.Driver", (Object)mySqlProps);
        build.put((Object)"org.mariadb.jdbc.Driver", (Object)mySqlProps);
        PROTOCOL_SPECIFIC_PROPS = build.build();
        PATH_CANONICALIZERS = ImmutableMap.of((Object)"h2", (plugin, orig) -> {
            Path origPath;
            org.h2.engine.ConnectionInfo h2Info = new org.h2.engine.ConnectionInfo(orig);
            if (!h2Info.isPersistent() || h2Info.isRemote()) {
                return orig;
            }
            if (orig.startsWith("file:")) {
                orig = orig.substring("file:".length());
            }
            if ((origPath = Paths.get(orig, new String[0])).isAbsolute()) {
                return origPath.toString();
            }
            return Sponge.getConfigManager().getPluginConfig((PluginContainer)plugin).getDirectory().resolve((String)orig).toAbsolutePath().toString();
        });
    }

    public static class ConnectionInfo {
        private static final Pattern URL_REGEX = Pattern.compile("(?:jdbc:)?([^:]+):(//)?(?:([^:]+)(?::([^@]+))?@)?(.*)");
        private static final String UTF_8 = StandardCharsets.UTF_8.name();
        @Nullable
        private final String user;
        @Nullable
        private final String password;
        private final String driverClassName;
        private final String authlessUrl;
        private final String fullUrl;

        public ConnectionInfo(@Nullable String user, @Nullable String password, String driverClassName, String authlessUrl, String fullUrl) {
            this.user = user;
            this.password = password;
            this.driverClassName = driverClassName;
            this.authlessUrl = authlessUrl;
            this.fullUrl = fullUrl;
        }

        @Nullable
        public String getUser() {
            return this.user;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getAuthlessUrl() {
            return this.authlessUrl;
        }

        public String getFullUrl() {
            return this.fullUrl;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionInfo that = (ConnectionInfo)o;
            return Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.password, (Object)that.password) && Objects.equal((Object)this.driverClassName, (Object)that.driverClassName) && Objects.equal((Object)this.authlessUrl, (Object)that.authlessUrl) && Objects.equal((Object)this.fullUrl, (Object)that.fullUrl);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.user, this.password, this.driverClassName, this.authlessUrl, this.fullUrl});
        }

        public static ConnectionInfo fromUrl(@Nullable PluginContainer container, String fullUrl) throws SQLException {
            Matcher match = URL_REGEX.matcher(fullUrl);
            if (!match.matches()) {
                throw new IllegalArgumentException("URL " + fullUrl + " is not a valid JDBC URL");
            }
            String protocol = match.group(1);
            boolean hasSlashes = match.group(2) != null;
            String user = ConnectionInfo.urlDecode(match.group(3));
            String pass = ConnectionInfo.urlDecode(match.group(4));
            String serverDatabaseSpecifier = match.group(5);
            BiFunction<PluginContainer, String, String> derelativizer = PATH_CANONICALIZERS.get(protocol);
            if (container != null && derelativizer != null) {
                serverDatabaseSpecifier = derelativizer.apply(container, serverDatabaseSpecifier);
            }
            String unauthedUrl = "jdbc:" + protocol + (hasSlashes ? "://" : ":") + serverDatabaseSpecifier;
            String driverClass = DriverManager.getDriver(unauthedUrl).getClass().getCanonicalName();
            return new ConnectionInfo(user, pass, driverClass, unauthedUrl, fullUrl);
        }

        private static String urlDecode(String str) {
            try {
                return str == null ? null : URLDecoder.decode(str, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 is not supported on this system", e);
            }
        }
    }
}

