/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import java.util.function.Supplier;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.IntegerProperty;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.common.util.DataUtil;

public final class BoundedUtil {
    public static Value<Double> constructImmutableValueDouble(Double value, Supplier<? extends Key<? extends Value<Double>>> key, IProperty<Double> property) {
        double min2 = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        return Value.immutableOf(key, value < min2 || value > max ? null : value);
    }

    public static Value<Double> constructMutableValueDouble(Double value, Supplier<? extends Key<? extends Value<Double>>> key, IProperty<Double> property) {
        double min2 = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        return Value.mutableOf(key, value < min2 || value > max ? null : value);
    }

    public static Value<Integer> constructImmutableValueInteger(Integer value, Supplier<? extends Key<? extends Value<Integer>>> key, IntegerProperty property) {
        int min2 = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        return Value.immutableOf(key, value < min2 || value > max ? null : value);
    }

    public static Value<Integer> constructMutableValueInteger(Integer value, Supplier<? extends Key<? extends Value<Integer>>> key, IntegerProperty property) {
        int min2 = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        return Value.mutableOf(key, value < min2 || value > max ? null : value);
    }

    public static <H extends IStateHolder<H>> H setDouble(H holder, Double value, IProperty<Double> property) {
        double min2 = DataUtil.mind(property);
        double max = DataUtil.maxd(property);
        if (value < min2 || value > max) {
            return holder;
        }
        return (H)((IStateHolder)holder.with(property, (Comparable)value));
    }

    public static <H extends IStateHolder<H>> H setDoubleLower(H holder, Double value, IProperty<Double> property) {
        double min2 = DataUtil.mind(property);
        if (value < min2) {
            return holder;
        }
        return (H)((IStateHolder)holder.with(property, (Comparable)value));
    }

    public static <H extends IStateHolder<H>> H setDoubleUpper(H holder, Double value, IProperty<Double> property) {
        double max = DataUtil.maxd(property);
        if (value > max) {
            return holder;
        }
        return (H)((IStateHolder)holder.with(property, (Comparable)value));
    }

    public static <H extends IStateHolder<H>> H setInteger(H holder, Integer value, IntegerProperty property) {
        int min2 = DataUtil.mini(property);
        int max = DataUtil.maxi(property);
        if (value < min2 || value > max) {
            return holder;
        }
        return (H)((IStateHolder)holder.with((IProperty)property, (Comparable)value));
    }

    public static <H extends IStateHolder<H>> H setIntegerLower(H holder, Integer value, IntegerProperty property) {
        int min2 = DataUtil.mini(property);
        if (value < min2) {
            return holder;
        }
        return (H)((IStateHolder)holder.with((IProperty)property, (Comparable)value));
    }

    public static <H extends IStateHolder<H>> H setIntegerUpper(H holder, Integer value, IntegerProperty property) {
        int max = DataUtil.maxi(property);
        if (value > max) {
            return holder;
        }
        return (H)((IStateHolder)holder.with((IProperty)property, (Comparable)value));
    }

    private BoundedUtil() {
    }
}

