/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.storage.SaveHandler;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.ChunkRegenerateContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.math.vector.Vector3i;

public final class ChunkUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Chunk> regenerateChunk(ServerWorld world, int cx, int cy, int cz, ChunkRegenerateFlag flag) {
        Chunk spongeChunk;
        try (Object context = GenerationPhase.State.CHUNK_REGENERATING_LOAD_EXISTING.createPhaseContext(PhaseTracker.SERVER).world((World)world);){
            ((PhaseContext)context).buildAndSwitch();
            spongeChunk = world.loadChunk(cx, cy, cz, false).orElse(null);
        }
        if (spongeChunk == null) {
            if (!flag.create()) {
                return Optional.empty();
            }
            return world.loadChunk(cx, cy, cz, true);
        }
        net.minecraft.world.chunk.Chunk chunk = (net.minecraft.world.chunk.Chunk)spongeChunk;
        boolean keepEntities = flag.entities();
        try (ChunkRegenerateContext context = GenerationPhase.State.CHUNK_REGENERATING.createPhaseContext(PhaseTracker.SERVER).chunk(chunk);){
            context.buildAndSwitch();
            for (ClassInheritanceMultiMap multiEntityList : chunk.getEntityLists()) {
                for (Entity entity : multiEntityList) {
                    if (keepEntities || entity instanceof ServerPlayerEntity) continue;
                    entity.remove();
                }
            }
            ServerChunkProvider chunkProviderServer = (ServerChunkProvider)chunk.getWorld().getChunkProvider();
            File saveFolder = Files.createTempDir();
            saveFolder.deleteOnExit();
            try {
                net.minecraft.world.server.ServerWorld originalWorld = (net.minecraft.world.server.ServerWorld)world;
                MinecraftServer server = originalWorld.getServer();
                SaveHandler saveHandler = new SaveHandler(saveFolder, originalWorld.getSaveHandler().getWorldDirectory().getName(), server, server.getDataFixer());
                try (net.minecraft.world.server.ServerWorld freshWorld = new net.minecraft.world.server.ServerWorld(server, server.getBackgroundExecutor(), saveHandler, originalWorld.getWorldInfo(), originalWorld.dimension.getType(), originalWorld.getProfiler(), (IChunkStatusListener)new NoOpChunkStatusListener());){
                    for (int z = cz - 1; z <= cz + 1; ++z) {
                        for (int x = cx - 1; x <= cx + 1; ++x) {
                            freshWorld.getChunk(x, z);
                        }
                    }
                    Vector3i blockMin = spongeChunk.getBlockMin();
                    Vector3i blockMax = spongeChunk.getBlockMax();
                    for (int z = blockMin.getZ(); z <= blockMax.getZ(); ++z) {
                        for (int y = blockMin.getY(); y <= blockMax.getY(); ++y) {
                            for (int x = blockMin.getX(); x <= blockMax.getX(); ++x) {
                                BlockPos pos = new BlockPos(x, y, z);
                                chunk.setBlockState(pos, freshWorld.getBlockState(pos), false);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                saveFolder.delete();
            }
            chunkProviderServer.chunkManager.getTrackingPlayers(new ChunkPos(cx, cz), false).forEach(player -> {
                player.connection.sendPacket((IPacket)new SChunkDataPacket(chunk, 65534));
                player.connection.sendPacket((IPacket)new SChunkDataPacket(chunk, 1));
            });
            Optional<Chunk> optional = Optional.of((Chunk)chunk);
            return optional;
        }
    }

    private ChunkUtil() {
    }

    public static class NoOpChunkStatusListener
    implements IChunkStatusListener {
        public void start(ChunkPos center) {
        }

        public void statusChanged(ChunkPos p_219508_1_, @Nullable ChunkStatus p_219508_2_) {
        }

        public void stop() {
        }
    }
}

