/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import org.spongepowered.api.util.Direction;

public final class DirectionalUtil {
    public static Set<Direction> getHorizontalFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south) {
        ImmutableMap sides = ImmutableMap.of((Object)((Object)Direction.EAST), (Object)east, (Object)((Object)Direction.WEST), (Object)west, (Object)((Object)Direction.NORTH), (Object)north, (Object)((Object)Direction.SOUTH), (Object)south);
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Set<Direction> getHorizontalUpFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).build();
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Set<Direction> getHorizontalUpDownFrom(BlockState holder, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up, BooleanProperty down) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).put((Object)Direction.DOWN, (Object)down).build();
        return DirectionalUtil.getFrom(holder, (Map<Direction, BooleanProperty>)sides);
    }

    public static Set<Direction> getFrom(BlockState holder, Map<Direction, BooleanProperty> sides) {
        HashSet<Direction> directions = new HashSet<Direction>();
        for (Map.Entry<Direction, BooleanProperty> entry : sides.entrySet()) {
            if (!((Boolean)holder.get((IProperty)entry.getValue())).booleanValue()) continue;
            directions.add(entry.getKey());
        }
        return directions;
    }

    public static BlockState setHorizontal(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState setHorizontalUpFor(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState setHorizontalUpDownFor(BlockState holder, Set<Direction> value, BooleanProperty east, BooleanProperty west, BooleanProperty north, BooleanProperty south, BooleanProperty up, BooleanProperty down) {
        ImmutableMap sides = ImmutableMap.builder().put((Object)Direction.EAST, (Object)east).put((Object)Direction.WEST, (Object)west).put((Object)Direction.NORTH, (Object)north).put((Object)Direction.SOUTH, (Object)south).put((Object)Direction.UP, (Object)up).put((Object)Direction.DOWN, (Object)down).build();
        return DirectionalUtil.set(holder, value, (Map<Direction, BooleanProperty>)sides);
    }

    public static BlockState set(BlockState holder, Set<Direction> value, Map<Direction, BooleanProperty> sides) {
        for (Map.Entry<Direction, BooleanProperty> entry : sides.entrySet()) {
            holder = (BlockState)holder.with((IProperty)entry.getValue(), (Comparable)Boolean.valueOf(value.contains((Object)entry.getKey())));
        }
        return holder;
    }

    private DirectionalUtil() {
    }
}

