/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class NBTUtil {
    public static @Nullable Boolean getNullableBoolean(CompoundNBT compound, String key) {
        INBT tag = compound.get(key);
        if (tag instanceof NumberNBT) {
            return ((NumberNBT)tag).getByte() != 0;
        }
        return null;
    }

    public static @Nullable CompoundNBT getNullableCompound(CompoundNBT compound, String key) {
        if (!compound.contains(key, 10)) {
            return null;
        }
        return compound.getCompound(key);
    }

    public static CompoundNBT getOrCreateCompound(CompoundNBT compound, String key) {
        if (!compound.contains(key, 10)) {
            CompoundNBT child = new CompoundNBT();
            compound.put(key, (INBT)child);
            return child;
        }
        return compound.getCompound(key);
    }

    private NBTUtil() {
    }
}

