/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

public final class SpongeLocatableBlock
implements LocatableBlock {
    private final BlockState blockState;
    private final ResourceKey world;
    private final Vector3i position;
    private final WeakReference<ServerWorld> worldRef;
    @Nullable
    private ServerLocation location;

    SpongeLocatableBlock(SpongeLocatableBlockBuilder builder) {
        this.blockState = (BlockState)Preconditions.checkNotNull((Object)builder.blockState.get(), (Object)"blockstate");
        this.position = (Vector3i)Preconditions.checkNotNull((Object)builder.position.get(), (Object)"position");
        this.world = (ResourceKey)Preconditions.checkNotNull((Object)builder.world.get(), (Object)"world");
        this.worldRef = new WeakReference<Object>(Preconditions.checkNotNull((Object)builder.worldReference.get(), (Object)"reference"));
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    public ServerLocation getLocation() {
        if (this.location == null) {
            this.location = ServerLocation.of((ServerWorld)this.worldRef.get(), this.position);
        }
        return this.location;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, 1).set(Queries.WORLD_KEY, this.world).set(Queries.POSITION_X, this.position.getX()).set(Queries.POSITION_Y, this.position.getY()).set(Queries.POSITION_Z, this.position.getZ()).set(Constants.Block.BLOCK_STATE, this.blockState);
    }

    @Override
    public <E> Optional<E> get(Key<? extends Value<E>> key) {
        return this.blockState.get(key);
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(Key<V> key) {
        return this.blockState.getValue(key);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.blockState.supports(key);
    }

    @Override
    public LocatableBlock copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.blockState.getKeys();
    }

    @Override
    public Set<Value.Immutable<?>> getValues() {
        return this.blockState.getValues();
    }

    @Override
    public <E> Optional<LocatableBlock> transform(Key<? extends Value<E>> key, Function<E, E> function) {
        return this.blockState.transform(key, function).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public <E> Optional<LocatableBlock> with(Key<? extends Value<E>> key, E value) {
        return this.blockState.with(key, value).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public Optional<LocatableBlock> with(Value<?> value) {
        return this.blockState.with(value).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public Optional<LocatableBlock> without(Key<?> key) {
        return this.blockState.without(key).map(state -> LocatableBlock.builder().from(this).state((BlockState)state).build());
    }

    @Override
    public LocatableBlock withRawData(DataView container) throws InvalidDataException {
        return LocatableBlock.builder().from(this).state((BlockState)this.blockState.withRawData(container)).build();
    }

    @Override
    public LocatableBlock mergeWith(LocatableBlock that, MergeFunction function) {
        return LocatableBlock.builder().from(this).state(this.blockState.mergeWith(that.getBlockState(), function)).build();
    }

    @Override
    public boolean validateRawData(DataView container) {
        return this.blockState.validateRawData(container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeLocatableBlock that = (SpongeLocatableBlock)o;
        return Objects.equal((Object)this.blockState, (Object)that.blockState) && Objects.equal((Object)this.position, (Object)that.position) && Objects.equal((Object)this.world, (Object)that.world);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.blockState, this.position, this.world});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockState", (Object)this.blockState).add("world", (Object)this.world).add("position", (Object)this.position).toString();
    }
}

